/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.contract.wiremock.WireMockProperties;
import org.springframework.cloud.contract.wiremock.WireMockSpring;
import org.springframework.cloud.contract.wiremock.file.ResourcesFileSource;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={WireMockProperties.class})
public class WireMockConfiguration
implements SmartLifecycle {
    private volatile boolean running;
    private WireMockServer server;
    @Autowired(required=false)
    private Options options;
    @Autowired
    private DefaultListableBeanFactory beanFactory;
    @Autowired
    private WireMockProperties wireMock;
    @Autowired
    private ResourceLoader resourceLoader;

    @PostConstruct
    public void init() throws IOException {
        if (this.options == null) {
            com.github.tomakehurst.wiremock.core.WireMockConfiguration factory = WireMockSpring.options();
            if (this.wireMock.getPort() != 8080) {
                factory.port(this.wireMock.getPort());
            }
            if (this.wireMock.getHttpsPort() != -1) {
                factory.httpsPort(Integer.valueOf(this.wireMock.getHttpsPort()));
            }
            this.registerFiles(factory);
            this.options = factory;
        }
        this.server = new WireMockServer(this.options);
        this.registerStubs();
        if (!this.beanFactory.containsBean("wireMockServer")) {
            this.beanFactory.registerSingleton("wireMockServer", (Object)this.server);
        }
    }

    private void registerStubs() throws IOException {
        for (String stubs : this.wireMock.getStubs()) {
            if (!StringUtils.hasText((String)stubs)) continue;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
            String pattern = stubs;
            if (!pattern.contains("*")) {
                if (!pattern.endsWith("/")) {
                    pattern = pattern + "/";
                }
                pattern = pattern + "**/*.json";
            }
            for (Resource resource : resolver.getResources(pattern)) {
                this.server.addStubMapping(StubMapping.buildFrom((String)StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)Charset.forName("UTF-8"))));
            }
        }
    }

    private void registerFiles(com.github.tomakehurst.wiremock.core.WireMockConfiguration factory) throws IOException {
        for (String files : this.wireMock.getFiles()) {
            if (!StringUtils.hasText((String)files)) continue;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
            String pattern = files;
            if (!pattern.endsWith("/")) {
                pattern = pattern + "/";
            }
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (Resource resource : resolver.getResources(pattern)) {
                if (!resource.exists()) continue;
                resources.add(resource);
            }
            ResourcesFileSource fileSource = new ResourcesFileSource(resources.toArray(new Resource[0]));
            factory.fileSource((FileSource)fileSource);
        }
    }

    public void start() {
        this.server.start();
        WireMock.configureFor((String)"localhost", (int)this.server.port());
        this.running = true;
    }

    public void stop() {
        if (this.running) {
            this.server.stop();
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

