/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util.xml;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.StaticContext;
import org.eclipse.wst.xml.xpath2.api.XPath2Expression;
import org.eclipse.wst.xml.xpath2.processor.Engine;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.util.DynamicContextBuilder;
import org.springframework.cloud.contract.verifier.util.xml.ArrayValueAssertion;
import org.springframework.cloud.contract.verifier.util.xml.FieldAssertion;
import org.springframework.cloud.contract.verifier.util.xml.ReadyToCheckAsserter;
import org.springframework.cloud.contract.verifier.util.xml.XmlArrayVerifiable;
import org.springframework.cloud.contract.verifier.util.xml.XmlAsserterConfiguration;
import org.springframework.cloud.contract.verifier.util.xml.XmlCachedObjects;
import org.springframework.cloud.contract.verifier.util.xml.XmlVerifiable;
import org.springframework.util.StringUtils;

class XmlAsserter
implements XmlVerifiable {
    private static final Log log = LogFactory.getLog(XmlAsserter.class);
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");
    final XmlCachedObjects cachedObjects;
    final LinkedList<String> xPathBuffer;
    final LinkedList<String> specialCaseXPathBuffer;
    final Object fieldName;
    final XmlAsserterConfiguration xmlAsserterConfiguration;

    XmlAsserter(XmlCachedObjects cachedObjects, LinkedList<String> xPathBuffer, LinkedList<String> specialCaseXPathBuffer, Object fieldName, XmlAsserterConfiguration xmlAsserterConfiguration) {
        this.cachedObjects = cachedObjects;
        this.xPathBuffer = new LinkedList<String>(xPathBuffer);
        this.specialCaseXPathBuffer = new LinkedList<String>(specialCaseXPathBuffer);
        this.fieldName = fieldName;
        this.xmlAsserterConfiguration = xmlAsserterConfiguration;
    }

    XmlAsserter(XmlAsserter asserter) {
        this.cachedObjects = asserter.cachedObjects;
        this.xPathBuffer = new LinkedList<String>(asserter.xPathBuffer);
        this.specialCaseXPathBuffer = new LinkedList<String>(asserter.specialCaseXPathBuffer);
        this.fieldName = asserter.fieldName;
        this.xmlAsserterConfiguration = asserter.xmlAsserterConfiguration;
    }

    static String escapeText(Object object) {
        String string = String.valueOf(object);
        if (!string.contains("'")) {
            return XmlAsserter.wrapValueWithSingleQuotes(string);
        }
        String[] split = string.split("'");
        LinkedList<String> list = new LinkedList<String>();
        list.add("concat(");
        for (String splitString : split) {
            list.add("'" + splitString + "'");
            list.add(",");
            list.add("\"'\"");
            list.add(",");
        }
        list.removeLast();
        list.removeLast();
        list.removeLast();
        list.add(")");
        return XmlAsserter.buildStringFromList(list);
    }

    static String escapeRegex(Object object) {
        return String.valueOf(object);
    }

    private static String escapeSpecialRegexChars(String str) {
        return SPECIAL_REGEX_CHARS.matcher(str).replaceAll("\\\\$0");
    }

    private static String buildStringFromList(List<String> list) {
        StringBuilder builder = new StringBuilder();
        for (String string : list) {
            builder.append(string);
        }
        return builder.toString();
    }

    private static String wrapValueWithSingleQuotes(Object value) {
        return value instanceof String ? "'" + String.valueOf(value) + "'" : value.toString();
    }

    @Override
    public FieldAssertion node(String value) {
        FieldAssertion asserter = new FieldAssertion(this.cachedObjects, this.xPathBuffer, this.specialCaseXPathBuffer, value, this.xmlAsserterConfiguration);
        asserter.xPathBuffer.offer(String.valueOf(value));
        asserter.xPathBuffer.offer("/");
        return asserter;
    }

    @Override
    public FieldAssertion nodeWithDefaultNamespace(String value, String defaultNamespace) {
        FieldAssertion asserter = new FieldAssertion(this.cachedObjects, this.xPathBuffer, this.specialCaseXPathBuffer, value, this.xmlAsserterConfiguration);
        Object path = String.format("*[local-name()='%s'", value);
        if (StringUtils.hasText((String)defaultNamespace)) {
            path = (String)path + String.format(" and namespace-uri()='%s'", defaultNamespace);
        }
        path = (String)path + "]";
        asserter.xPathBuffer.offer(path);
        asserter.xPathBuffer.offer("/");
        return asserter;
    }

    @Override
    public XmlVerifiable withAttribute(String attribute, String attributeValue) {
        FieldAssertion asserter = new FieldAssertion(this.cachedObjects, this.xPathBuffer, this.specialCaseXPathBuffer, this.fieldName, this.xmlAsserterConfiguration);
        if (((String)asserter.xPathBuffer.peekLast()).equals("/")) {
            asserter.xPathBuffer.removeLast();
        }
        if (this.isReadyToCheck()) {
            asserter.xPathBuffer.offer("/" + String.valueOf(this.fieldName));
        }
        asserter.xPathBuffer.offer("[@" + String.valueOf(attribute) + "=" + XmlAsserter.escapeText(attributeValue) + "]");
        this.updateCurrentBuffer(asserter);
        asserter.checkBufferedXPathString();
        return asserter;
    }

    @Override
    public XmlVerifiable withAttribute(String attribute) {
        FieldAssertion asserter = new FieldAssertion(this.cachedObjects, this.xPathBuffer, this.specialCaseXPathBuffer, this.fieldName, this.xmlAsserterConfiguration);
        String path = "@" + attribute;
        if (attribute.startsWith("xmlns:")) {
            path = "namespace::" + attribute.substring("xmlns:".length());
        }
        asserter.xPathBuffer.offer(path);
        this.updateCurrentBuffer(asserter);
        asserter.checkBufferedXPathString();
        return asserter;
    }

    @Override
    public XmlVerifiable text() {
        FieldAssertion asserter = new FieldAssertion(this.cachedObjects, this.xPathBuffer, this.specialCaseXPathBuffer, this.fieldName, this.xmlAsserterConfiguration);
        asserter.xPathBuffer.offer("text()");
        return asserter;
    }

    @Override
    public XmlVerifiable index(int index) {
        FieldAssertion asserter = new FieldAssertion(this.cachedObjects, this.xPathBuffer, this.specialCaseXPathBuffer, this.fieldName, this.xmlAsserterConfiguration);
        if (((String)asserter.xPathBuffer.peekLast()).equals("/")) {
            asserter.xPathBuffer.removeLast();
        }
        asserter.xPathBuffer.offer("[" + index + "]");
        asserter.xPathBuffer.offer("/");
        return asserter;
    }

    @Override
    public FieldAssertion node(String ... nodeNames) {
        XmlAsserter assertion = null;
        for (String field : nodeNames) {
            assertion = assertion == null ? this.node(field) : assertion.node(field);
        }
        return assertion;
    }

    @Override
    public XmlArrayVerifiable array(String value) {
        ArrayValueAssertion asserter = new ArrayValueAssertion(this.cachedObjects, this.xPathBuffer, this.specialCaseXPathBuffer, value, this.xmlAsserterConfiguration);
        asserter.xPathBuffer.offer(String.valueOf(value));
        asserter.xPathBuffer.offer("/");
        return asserter;
    }

    @Override
    public XmlVerifiable isEqualTo(String value) {
        if (value == null) {
            return this.isNull();
        }
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.cachedObjects, this.xPathBuffer, this.fieldName, this.xmlAsserterConfiguration);
        this.removeLastFieldElement(readyToCheck);
        readyToCheck.xPathBuffer.offer("[" + String.valueOf(this.fieldName) + "=" + XmlAsserter.escapeText(value) + "]");
        this.updateCurrentBuffer(readyToCheck);
        readyToCheck.checkBufferedXPathString();
        return readyToCheck;
    }

    private void updateCurrentBuffer(XmlAsserter readyToCheck) {
        this.xPathBuffer.clear();
        this.xPathBuffer.addAll(readyToCheck.xPathBuffer);
    }

    @Override
    public XmlVerifiable isEqualTo(Object value) {
        if (value == null) {
            return this.isNull();
        }
        if (value instanceof Number) {
            return this.isEqualTo((Number)value);
        }
        if (value instanceof Boolean) {
            return this.isEqualTo((Boolean)value);
        }
        if (value instanceof Pattern) {
            return this.matches(((Pattern)value).pattern());
        }
        return this.isEqualTo(value.toString());
    }

    @Override
    public XmlVerifiable isEqualTo(Number value) {
        if (value == null) {
            return this.isNull();
        }
        return this.xmlVerifiableFromObject(value);
    }

    private XmlVerifiable xmlVerifiableFromObject(Object value) {
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.cachedObjects, this.xPathBuffer, this.fieldName, this.xmlAsserterConfiguration);
        this.removeLastFieldElement(readyToCheck);
        readyToCheck.xPathBuffer.offer("[" + String.valueOf(this.fieldName) + "=" + String.valueOf(value) + "]");
        this.updateCurrentBuffer(readyToCheck);
        readyToCheck.checkBufferedXPathString();
        return readyToCheck;
    }

    protected void removeLastFieldElement(XmlAsserter readyToCheck) {
        readyToCheck.xPathBuffer.removeLast();
        readyToCheck.xPathBuffer.removeLast();
        readyToCheck.xPathBuffer.removeLast();
    }

    @Override
    public XmlVerifiable isNull() {
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.cachedObjects, this.xPathBuffer, this.fieldName, this.xmlAsserterConfiguration);
        String xpath = this.createXPathString();
        readyToCheck.xPathBuffer.clear();
        readyToCheck.xPathBuffer.offer("not(boolean(" + xpath + "/text()[1]))");
        this.updateCurrentBuffer(readyToCheck);
        readyToCheck.checkBufferedXPathString();
        return readyToCheck;
    }

    @Override
    public XmlVerifiable matches(String value) {
        if (value == null) {
            return this.isNull();
        }
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.cachedObjects, this.xPathBuffer, this.fieldName, this.xmlAsserterConfiguration);
        this.removeLastFieldElement(readyToCheck);
        readyToCheck.xPathBuffer.offer("[matches(" + String.valueOf(this.fieldName) + ", " + XmlAsserter.escapeText(XmlAsserter.escapeRegex(value)) + ")]");
        this.updateCurrentBuffer(readyToCheck);
        readyToCheck.checkBufferedXPathString();
        return readyToCheck;
    }

    @Override
    public XmlVerifiable isEqualTo(Boolean value) {
        if (value == null) {
            return this.isNull();
        }
        return this.isEqualTo(String.valueOf(value));
    }

    @Override
    public XmlVerifiable withoutThrowingException() {
        this.xmlAsserterConfiguration.ignoreXPathException = true;
        return this;
    }

    protected void check(String xPathString) {
        boolean xpathMatched;
        if (this.xmlAsserterConfiguration.ignoreXPathException) {
            log.trace((Object)"WARNING!!! Overriding verification of the XPath. Your tests may pass even though they shouldn't");
            return;
        }
        ResultSequence expr = this.resultSequence(xPathString);
        boolean bl = xpathMatched = !expr.empty();
        if (!xpathMatched) {
            throw new IllegalStateException("Parsed XML [" + this.cachedObjects.xmlAsString + "] doesn't match the XPath <" + xPathString + ">");
        }
    }

    ResultSequence resultSequence(String xPathString) {
        return this.xPathExpression(xPathString);
    }

    private ResultSequence xPathExpression(String xPathString) {
        try {
            XPath2Expression expr = new Engine().parseExpression(xPathString, (StaticContext)this.cachedObjects.xpathBuilder);
            return expr.evaluate((DynamicContext)new DynamicContextBuilder((StaticContext)this.cachedObjects.xpathBuilder), new Object[]{this.cachedObjects.document});
        }
        catch (Exception e) {
            throw new XmlAsserterXpathException(this.xPath(), this.cachedObjects.xmlAsString, e);
        }
    }

    void checkBufferedXPathString() {
        this.check(this.createXPathString());
    }

    String createXPathString() {
        return this.createXPathString(this.xPathBuffer);
    }

    String createSpecialCaseXPathString() {
        return this.createXPathString(this.specialCaseXPathBuffer);
    }

    String createXPathString(LinkedList<String> buffer) {
        LinkedList<String> queue = new LinkedList<String>(buffer);
        StringBuilder stringBuffer = new StringBuilder();
        while (!queue.isEmpty()) {
            String value = queue.remove();
            if (queue.isEmpty() && value.equals("/")) continue;
            stringBuffer.append(value);
        }
        return stringBuffer.toString();
    }

    @Override
    public String xPath() {
        if (!this.specialCaseXPathBuffer.isEmpty()) {
            return this.createSpecialCaseXPathString();
        }
        return this.createXPathString();
    }

    @Override
    public void matchesXPath(String xPath) {
        this.check(xPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlAsserter that = (XmlAsserter)o;
        if (!this.xPathBuffer.equals(that.xPathBuffer)) {
            return false;
        }
        return this.fieldName != null ? this.fieldName.equals(that.fieldName) : that.fieldName == null;
    }

    public int hashCode() {
        int result = this.xPathBuffer.hashCode();
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "\\nAsserter{\n    xPathBuffer=" + String.valueOf(this.xPathBuffer) + "\n}";
    }

    @Override
    public boolean isIteratingOverArray() {
        return false;
    }

    @Override
    public boolean isAssertingAValueInArray() {
        return false;
    }

    @Override
    public String read() {
        String xpath = this.xPath();
        ResultSequence expr = this.resultSequence(xpath);
        if (expr.empty()) {
            throw new XmlAsserterXpathException(this.xPath(), this.cachedObjects.xmlAsString);
        }
        if (expr instanceof ElementType) {
            return ((ElementType)expr).getStringValue();
        }
        throw new UnsupportedOperationException("Can't return values of complex types");
    }

    protected boolean isReadyToCheck() {
        return false;
    }

    private static class XmlAsserterXpathException
    extends RuntimeException {
        XmlAsserterXpathException(String xPath, String xmlAsString) {
            super("Exception occurred while trying to evaluate XPath [" + xPath + "] from XML [" + xmlAsString + "]");
        }

        XmlAsserterXpathException(String xPath, String xmlAsString, Exception e) {
            super("Exception occurred while trying to evaluate XPath [" + xPath + "] from XML [" + xmlAsString + "]", e);
        }
    }
}

