/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.camel;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierReceiver;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.camel.CamelStubMessages;
import org.springframework.cloud.contract.verifier.messaging.camel.ContractVerifierCamelHelper;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.jms.ContractVerifierJmsConfiguration;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpContractVerifierAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Message.class})
@Import(value={CamelAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.contract.stubrunner.camel.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={NoOpContractVerifierAutoConfiguration.class, ContractVerifierJmsConfiguration.class})
public class ContractVerifierCamelConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MessageVerifierSender.class})
    MessageVerifierSender<Message> camelContractVerifierMessageSender(CamelContext camelContext, ProducerTemplate producerTemplate, ConsumerTemplate consumerTemplate) {
        final CamelStubMessages camelStubMessages = new CamelStubMessages(camelContext, producerTemplate, consumerTemplate);
        return new MessageVerifierSender<Message>(this){
            final /* synthetic */ ContractVerifierCamelConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void send(Message message, String destination, @Nullable YamlContract contract) {
                camelStubMessages.send(message, destination, contract);
            }

            @Override
            public <T> void send(T payload, Map<String, Object> headers, String destination, @Nullable YamlContract contract) {
                camelStubMessages.send(payload, headers, destination, contract);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageVerifierReceiver.class})
    MessageVerifierReceiver<Message> camelContractVerifierMessageReceiver(CamelContext camelContext, ProducerTemplate producerTemplate, ConsumerTemplate consumerTemplate) {
        final CamelStubMessages camelStubMessages = new CamelStubMessages(camelContext, producerTemplate, consumerTemplate);
        return new MessageVerifierReceiver<Message>(this){
            final /* synthetic */ ContractVerifierCamelConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Message receive(String destination, long timeout, TimeUnit timeUnit, @Nullable YamlContract contract) {
                return camelStubMessages.receive(destination, timeout, timeUnit, contract);
            }

            @Override
            public Message receive(String destination, YamlContract contract) {
                return camelStubMessages.receive(destination, contract);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={ContractVerifierMessaging.class})
    public ContractVerifierMessaging<Message> camelContractVerifierMessaging(MessageVerifierSender<Message> sender, MessageVerifierReceiver<Message> receiver) {
        return new ContractVerifierCamelHelper(sender, receiver);
    }
}

