/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.converter;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.verifier.converter.ContractsToYaml;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.converter.YamlToContracts;
import tools.jackson.dataformat.yaml.YAMLMapper;

public class YamlContractConverter
implements ContractConverter<List<YamlContract>> {
    private static final Logger log = LoggerFactory.getLogger(YamlContractConverter.class);
    public static final YamlContractConverter INSTANCE = new YamlContractConverter();
    private final YAMLMapper mapper = new YAMLMapper();
    private final YamlToContracts yamlToContracts = new YamlToContracts();
    private final ContractsToYaml contractsToYaml = new ContractsToYaml();

    public boolean isAccepted(File file) {
        boolean acceptFile;
        String name = file.getName();
        boolean bl = acceptFile = name.endsWith(".yml") || name.endsWith(".yaml");
        if (acceptFile) {
            try {
                this.yamlToContracts.convertFrom(file);
            }
            catch (Exception e) {
                log.warn("Error Processing yaml file. Skipping Contract Generation ", (Throwable)e);
                acceptFile = false;
            }
        }
        return acceptFile;
    }

    public Collection<Contract> convertFrom(File file) {
        return this.yamlToContracts.convertFrom(file);
    }

    public List<YamlContract> convertTo(Collection<Contract> contracts) {
        return this.contractsToYaml.convertTo(contracts);
    }

    public Map<String, byte[]> store(List<YamlContract> contracts) {
        return contracts.stream().collect(Collectors.toMap(this::name, this::getBytes));
    }

    public List<YamlContract> read(byte[] bytes) {
        try {
            return Collections.singletonList((YamlContract)this.mapper.readValue(bytes, YamlContract.class));
        }
        catch (Exception e) {
            return (List)this.mapper.readerForListOf(YamlContract.class).readValue(bytes);
        }
    }

    protected String name(YamlContract contract) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)contract.name, (CharSequence)String.valueOf(Math.abs(contract.hashCode()))) + ".yml";
    }

    protected byte[] getBytes(YamlContract yamlContract) {
        return this.mapper.writeValueAsString((Object)yamlContract).getBytes();
    }
}

