/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ClassMetaData;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.GeneratedTestClassBuilder;
import org.springframework.cloud.contract.verifier.builder.GroovyClassMetaData;
import org.springframework.cloud.contract.verifier.builder.JavaClassMetaData;

class MetaDataBuilder {
    private final GeneratedTestClassBuilder parentBuilder;
    private final BlockBuilder builder;
    private final GeneratedClassMetaData metaData;

    MetaDataBuilder(GeneratedTestClassBuilder generatedTestClassBuilder) {
        this.parentBuilder = generatedTestClassBuilder;
        this.builder = generatedTestClassBuilder.blockBuilder;
        this.metaData = generatedTestClassBuilder.generatedClassMetaData;
    }

    MetaDataBuilder java() {
        this.parentBuilder.metaData((ClassMetaData)new JavaClassMetaData(this.builder, this.metaData));
        return this;
    }

    MetaDataBuilder groovy() {
        this.parentBuilder.metaData((ClassMetaData)new GroovyClassMetaData(this.builder, this.metaData));
        return this;
    }

    GeneratedTestClassBuilder build() {
        return this.parentBuilder;
    }
}

