/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.file;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.OutputMessage;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.spec.internal.Response;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.cloud.contract.verifier.util.ContentUtils;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.util.Assert;

public class SingleContractMetadata {
    private static final Logger log = LoggerFactory.getLogger(SingleContractMetadata.class);
    private final ContractMetadata contractMetadata;
    private final Path stubsPath;
    private final Contract contract;
    private final List<Contract> allContracts;
    private final String definedInputStubContentType;
    private final ContentType inputStubContentType;
    private final ContentType evaluatedInputStubContentType;
    private final String definedOutputStubContentType;
    private final ContentType outputStubContentType;
    private final ContentType evaluatedOutputStubContentType;
    private final String definedInputTestContentType;
    private final ContentType inputTestContentType;
    private final ContentType evaluatedInputTestContentType;
    private final String definedOutputTestContentType;
    private final ContentType outputTestContentType;
    private final ContentType evaluatedOutputTestContentType;
    private String methodName;
    private final boolean http;

    public SingleContractMetadata(Contract currentContract, ContractMetadata contractMetadata) {
        Assert.notNull((Object)currentContract, (String)"Contract must not be null");
        this.allContracts = contractMetadata.getConvertedContract();
        this.contract = currentContract;
        this.contractMetadata = contractMetadata;
        Headers inputHeaders = this.inputHeaders(currentContract);
        DslProperty<?> inputBody = this.inputBody(currentContract);
        Headers outputHeaders = this.outputHeaders(currentContract);
        DslProperty<?> outputBody = this.outputBody(currentContract);
        Header inputContentType = this.contentTypeHeader(inputHeaders);
        Header outputContentType = this.contentTypeHeader(outputHeaders);
        this.definedInputTestContentType = Optional.ofNullable(inputContentType).map(DslProperty::getServerValue).map(Object::toString).orElse("");
        this.evaluatedInputTestContentType = this.tryToEvaluateTestContentType(inputHeaders, inputBody);
        this.inputTestContentType = inputBody != null ? this.evaluatedInputTestContentType : ContentType.UNKNOWN;
        this.definedOutputTestContentType = Optional.ofNullable(outputContentType).map(DslProperty::getServerValue).map(Object::toString).orElse("");
        this.evaluatedOutputTestContentType = this.tryToEvaluateTestContentType(outputHeaders, outputBody);
        this.outputTestContentType = outputBody != null ? this.evaluatedOutputTestContentType : ContentType.UNKNOWN;
        this.definedInputStubContentType = Optional.ofNullable(inputContentType).map(DslProperty::getClientValue).map(Object::toString).orElse("");
        this.evaluatedInputStubContentType = this.tryToEvaluateStubContentType(inputHeaders, inputBody);
        this.inputStubContentType = inputBody != null ? this.evaluatedInputStubContentType : ContentType.UNKNOWN;
        this.definedOutputStubContentType = Optional.ofNullable(outputContentType).map(DslProperty::getClientValue).map(Object::toString).orElse("");
        this.evaluatedOutputStubContentType = this.tryToEvaluateStubContentType(outputHeaders, outputBody);
        this.outputStubContentType = outputBody != null ? this.evaluatedOutputStubContentType : ContentType.UNKNOWN;
        this.http = currentContract.getRequest() != null;
        this.stubsPath = contractMetadata.getPath();
    }

    private Header contentTypeHeader(Headers headers) {
        return headers == null ? null : (Header)headers.getEntries().stream().filter(it -> "Content-Type".equalsIgnoreCase(it.getName())).findFirst().orElse(null);
    }

    private ContentType tryToEvaluateStubContentType(Headers mainHeaders, DslProperty<?> body) {
        Object clientValue = Optional.ofNullable(body).map(DslProperty::getClientValue).orElse(null);
        ContentType contentType = ContentUtils.evaluateClientSideContentType(mainHeaders, clientValue);
        if (contentType == ContentType.DEFINED || contentType == ContentType.UNKNOWN) {
            Object serverValue = Optional.ofNullable(body).map(DslProperty::getServerValue).orElse(null);
            return ContentUtils.evaluateServerSideContentType(mainHeaders, serverValue);
        }
        return contentType;
    }

    private ContentType tryToEvaluateTestContentType(Headers mainHeaders, DslProperty<?> body) {
        Object serverValue = Optional.ofNullable(body).map(DslProperty::getServerValue).orElse(null);
        ContentType contentType = ContentUtils.evaluateClientSideContentType(mainHeaders, serverValue);
        if (contentType == ContentType.DEFINED || contentType == ContentType.UNKNOWN) {
            Object clientValue = Optional.ofNullable(body).map(DslProperty::getClientValue).orElse(null);
            return ContentUtils.evaluateServerSideContentType(mainHeaders, clientValue);
        }
        return contentType;
    }

    public boolean isJson() {
        return this.inputTestContentType.equals((Object)ContentType.JSON) || this.outputTestContentType.equals((Object)ContentType.JSON) || this.inputStubContentType.equals((Object)ContentType.JSON) || this.outputStubContentType.equals((Object)ContentType.JSON);
    }

    public boolean evaluatesToJson() {
        return this.isJson() || this.evaluatedInputTestContentType.equals((Object)ContentType.JSON) || this.evaluatedOutputTestContentType.equals((Object)ContentType.JSON) || this.evaluatedInputStubContentType.equals((Object)ContentType.JSON) || this.evaluatedOutputStubContentType.equals((Object)ContentType.JSON);
    }

    public boolean isIgnored() {
        return this.contract.getIgnored() || this.contractMetadata.getIgnored();
    }

    public boolean isXml() {
        return this.inputTestContentType.equals((Object)ContentType.XML) || this.outputTestContentType.equals((Object)ContentType.XML) || this.inputStubContentType.equals((Object)ContentType.XML) || this.outputStubContentType.equals((Object)ContentType.XML);
    }

    public boolean isHttp() {
        return this.http;
    }

    public boolean isInProgress() {
        return this.contract.isInProgress();
    }

    public boolean isMessaging() {
        return !this.isHttp();
    }

    private DslProperty<?> inputBody(Contract contract) {
        return Optional.ofNullable(contract.getRequest()).map(Request::getBody).map(DslProperty.class::cast).orElse(null);
    }

    private Headers inputHeaders(Contract contract) {
        return Optional.ofNullable(contract.getRequest()).map(Request::getHeaders).orElse(null);
    }

    private DslProperty<?> outputBody(Contract contract) {
        return Optional.ofNullable(contract.getResponse()).map(Response::getBody).map(DslProperty.class::cast).orElseGet(() -> Optional.ofNullable(contract.getOutputMessage()).map(OutputMessage::getBody).orElse(null));
    }

    private Headers outputHeaders(Contract contract) {
        return Optional.ofNullable(contract.getResponse()).map(Response::getHeaders).orElseGet(() -> Optional.ofNullable(contract.getOutputMessage()).map(OutputMessage::getHeaders).orElse(null));
    }

    public String methodName() {
        if (this.methodName == null) {
            this.methodName = this.calculateMethodName();
        }
        return this.methodName;
    }

    private String calculateMethodName() {
        if (!NamesUtil.isEmpty(this.contract.getName())) {
            String name = NamesUtil.camelCase(NamesUtil.convertIllegalPackageChars(this.contract.getName()));
            log.trace("Overriding the default test name with [{}]", (Object)name);
            return name;
        }
        if (this.allContracts.size() > 1) {
            int index = this.allContracts.indexOf(this.getContract());
            String name = String.format("%s_%d", SingleContractMetadata.camelCasedMethodFromFileName(this.stubsPath), index);
            log.trace("Scenario found. The method name will be [{}]", (Object)name);
            return name;
        }
        String name = SingleContractMetadata.camelCasedMethodFromFileName(this.stubsPath);
        log.trace("The method name will be [{}]", (Object)name);
        return name;
    }

    private static String camelCasedMethodFromFileName(Path stubsPath) {
        return NamesUtil.camelCase(NamesUtil.convertIllegalMethodNameChars(NamesUtil.toLastDot(NamesUtil.afterLast(stubsPath.toString(), File.separator))));
    }

    public ContractMetadata getContractMetadata() {
        return this.contractMetadata;
    }

    public Contract getContract() {
        return this.contract;
    }

    public Collection<Contract> getAllContracts() {
        return this.allContracts;
    }

    public String getDefinedInputStubContentType() {
        return this.definedInputStubContentType;
    }

    public ContentType getInputStubContentType() {
        return this.inputStubContentType;
    }

    public ContentType getEvaluatedInputStubContentType() {
        return this.evaluatedInputStubContentType;
    }

    public String getDefinedOutputStubContentType() {
        return this.definedOutputStubContentType;
    }

    public ContentType getEvaluatedOutputStubContentType() {
        return this.evaluatedOutputStubContentType;
    }

    public String getDefinedInputTestContentType() {
        return this.definedInputTestContentType;
    }

    public ContentType getInputTestContentType() {
        return this.inputTestContentType;
    }

    public String getDefinedOutputTestContentType() {
        return this.definedOutputTestContentType;
    }

    public ContentType getOutputTestContentType() {
        return this.outputTestContentType;
    }

    public ContentType getEvaluatedOutputTestContentType() {
        return this.evaluatedOutputTestContentType;
    }
}

