/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.contract.verifier.util.VerifierObjectMapper;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public final class MetadataUtil {
    private static final ObjectMapper MAPPER = new VerifierObjectMapper();

    private MetadataUtil() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static <T> T fromMetadata(Map<String, Object> metadata, String key, T objectToMerge) {
        if (metadata == null || !metadata.containsKey(key)) {
            return objectToMerge;
        }
        return MetadataUtil.merge(objectToMerge, metadata.get(key));
    }

    public static <T> T merge(T objectToMerge, Object patch) {
        if (patch == null) {
            return objectToMerge;
        }
        byte[] bytes = new byte[]{};
        try {
            bytes = MAPPER.writer().writeValueAsBytes(patch);
            return (T)MAPPER.readerForUpdating(objectToMerge).readValue(bytes);
        }
        catch (Exception e) {
            if (e.getClass().toString().contains("InaccessibleObjectException") || e instanceof InvalidDefinitionException && e.getMessage().contains("InaccessibleObjectException")) {
                try {
                    YamlPropertiesFactoryBean yamlProcessor = new YamlPropertiesFactoryBean();
                    yamlProcessor.setResources(new Resource[]{new ByteArrayResource(bytes)});
                    Properties properties = yamlProcessor.getObject();
                    Object props = new Binder(new ConfigurationPropertySource[]{new MapConfigurationPropertySource(properties.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> entry.getValue().toString())))}).bind("", objectToMerge.getClass()).get();
                    BeanUtils.copyProperties((Object)props, objectToMerge);
                    return objectToMerge;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            throw new IllegalStateException(e);
        }
    }

    public static MetadataMap map() {
        return new MetadataMap();
    }

    public static class MetadataMap
    implements Map<String, Object> {
        private final Map<String, Object> delegate = new HashMap<String, Object>();

        public MetadataMap entry(String key, Object value) {
            this.put(key, value);
            return this;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return this.delegate.get(key);
        }

        @Override
        public Object put(String key, Object value) {
            return this.delegate.put(key, value);
        }

        @Override
        public Object remove(Object key) {
            return this.delegate.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            this.delegate.putAll(m);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

