/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.CustomModeAcceptor;
import org.springframework.cloud.contract.verifier.builder.CustomModeBodyGiven;
import org.springframework.cloud.contract.verifier.builder.CustomModeCookiesGiven;
import org.springframework.cloud.contract.verifier.builder.CustomModeHeadersGiven;
import org.springframework.cloud.contract.verifier.builder.CustomModeMethodWithUrlGiven;
import org.springframework.cloud.contract.verifier.builder.CustomModeQueryParamsGiven;
import org.springframework.cloud.contract.verifier.builder.CustomModeRequestBuildGiven;
import org.springframework.cloud.contract.verifier.builder.CustomModeRequestGiven;
import org.springframework.cloud.contract.verifier.builder.CustomModeSchemeProtocolGiven;
import org.springframework.cloud.contract.verifier.builder.CustomMultipartGiven;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.Given;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class CustomModeGiven
implements Given,
BodyMethodVisitor,
CustomModeAcceptor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final List<Given> requestGivens = new LinkedList<Given>();
    private final List<Given> bodyGivens = new LinkedList<Given>();

    CustomModeGiven(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
        this.requestGivens.addAll(Collections.singletonList(new CustomModeRequestGiven(blockBuilder, generatedClassMetaData)));
        this.bodyGivens.addAll(Arrays.asList(new CustomModeMethodWithUrlGiven(blockBuilder, bodyParser), new CustomModeQueryParamsGiven(blockBuilder, bodyParser), new CustomModeSchemeProtocolGiven(blockBuilder), new CustomModeHeadersGiven(blockBuilder), new CustomModeCookiesGiven(blockBuilder), new CustomModeBodyGiven(blockBuilder, generatedClassMetaData, bodyParser), new CustomMultipartGiven(generatedClassMetaData), new CustomModeRequestBuildGiven(blockBuilder)));
    }

    @Override
    public MethodVisitor<Given> apply(SingleContractMetadata singleContractMetadata) {
        this.startBodyBlock(this.blockBuilder, "given:");
        this.addRequestGivenLine(singleContractMetadata);
        this.indentedBodyBlock(this.blockBuilder, this.bodyGivens, singleContractMetadata);
        this.blockBuilder.addEmptyLine();
        return this;
    }

    private void addRequestGivenLine(SingleContractMetadata singleContractMetadata) {
        this.requestGivens.stream().filter(given -> given.accept(singleContractMetadata)).findFirst().orElseThrow(() -> new IllegalStateException("No matching request building Given implementation for a custom test mode")).apply(singleContractMetadata);
    }

    @Override
    public boolean accept(SingleContractMetadata singleContractMetadata) {
        return this.acceptType(this.generatedClassMetaData, singleContractMetadata);
    }
}

