/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.verifier.builder.CommunicationType;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassDataForMethod;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.util.Assert;

class BodyReader {
    private final GeneratedClassMetaData generatedClassMetaData;

    BodyReader(GeneratedClassMetaData generatedClassMetaData) {
        this.generatedClassMetaData = generatedClassMetaData;
    }

    String readBytesFromFileString(SingleContractMetadata metadata, FromFileProperty property, CommunicationType side) {
        String fileName = this.byteBodyToAFileForTestMethod(metadata, property, side);
        return "fileToBytes(this, \"" + fileName + "\")";
    }

    String readStringFromFileString(SingleContractMetadata metadata, FromFileProperty property, CommunicationType side) {
        if (!Charset.defaultCharset().toString().equals(property.getCharset())) {
            return "new String(" + this.readBytesFromFileString(metadata, property, side) + ", \"" + property.getCharset() + "\")";
        }
        return "new String(" + this.readBytesFromFileString(metadata, property, side) + ")";
    }

    private String byteBodyToAFileForTestMethod(SingleContractMetadata metadata, FromFileProperty property, CommunicationType side) {
        GeneratedClassDataForMethod classDataForMethod = new GeneratedClassDataForMethod(this.generatedClassMetaData.generatedClassData, metadata.methodName());
        String newFileName = classDataForMethod.getMethodName() + "_" + side.name().toLowerCase() + "_" + property.fileName();
        Path parent = classDataForMethod.testClassPath().getParent();
        if (parent == null) {
            parent = classDataForMethod.testClassPath();
        }
        File newFile = new File(parent.toFile(), newFileName);
        try {
            Files.write(newFile.toPath(), property.asBytes(), new OpenOption[0]);
            this.generatedTestResourcesFileBytes(property, newFile);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return newFileName;
    }

    private void generatedTestResourcesFileBytes(FromFileProperty property, File newFile) throws IOException {
        Assert.notNull((Object)this.generatedClassMetaData.configProperties.getGeneratedTestSourcesDir(), (String)"No generated test sources directory set");
        Assert.notNull((Object)this.generatedClassMetaData.configProperties.getGeneratedTestResourcesDir(), (String)"No generated test resources directory set");
        Path path = this.generatedClassMetaData.configProperties.getGeneratedTestSourcesDir().toPath();
        Path relativePath = path.relativize(newFile.toPath());
        File newFileInGeneratedTestSources = new File(this.generatedClassMetaData.configProperties.getGeneratedTestResourcesDir(), relativePath.toString());
        newFileInGeneratedTestSources.getParentFile().mkdirs();
        Files.write(newFileInGeneratedTestSources.toPath(), property.asBytes(), new OpenOption[0]);
    }
}

