/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.file;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.verifier.converter.YamlContractConverter;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContractVerifierDslConverter;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import wiremock.com.google.common.collect.HashMultiset;
import wiremock.com.google.common.collect.ListMultimap;
import wiremock.com.google.common.collect.Multimap;
import wiremock.com.google.common.collect.Multiset;

public class ContractFileScanner
implements GroovyObject {
    private static final String OS_NAME;
    private static final String OS_NAME_WINDOWS_PREFIX = "Windows";
    protected static final boolean IS_OS_WINDOWS;
    private static final String MATCH_PREFIX = "glob:";
    private static final Pattern SCENARIO_STEP_FILENAME_PATTERN;
    private final File baseDir;
    private final Set<PathMatcher> excludeMatchers;
    private final Set<PathMatcher> ignoreMatchers;
    private final Set<PathMatcher> includeMatchers;
    private final String includeMatcher;
    private static final transient Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ContractFileScanner(File baseDir, Set<String> excluded, Set<String> ignored, Set<String> included, String includeMatcher) {
        String string;
        File file;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.baseDir = file = baseDir;
        Set set = excluded;
        Set<PathMatcher> set2 = this.processPatterns(DefaultTypeTransformation.booleanUnbox(set) ? set : (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
        this.excludeMatchers = set2;
        Set set3 = ignored;
        Set<PathMatcher> set4 = this.processPatterns(DefaultTypeTransformation.booleanUnbox(set3) ? set3 : (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
        this.ignoreMatchers = set4;
        Set set5 = included;
        Set<PathMatcher> set6 = this.processPatterns(DefaultTypeTransformation.booleanUnbox(set5) ? set5 : (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
        this.includeMatchers = set6;
        this.includeMatcher = string = includeMatcher;
    }

    @Generated
    public ContractFileScanner(File baseDir, Set<String> excluded, Set<String> ignored, Set<String> included) {
        this(baseDir, excluded, ignored, included, "");
    }

    @Generated
    public ContractFileScanner(File baseDir, Set<String> excluded, Set<String> ignored) {
        this(baseDir, excluded, ignored, (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class), "");
    }

    private Set<PathMatcher> processPatterns(Set<String> patterns) {
        FileSystem fileSystem = FileSystems.getDefault();
        HashSet<PathMatcher> pathMatchers = new HashSet<PathMatcher>();
        String pattern = null;
        Iterator<String> iterator = patterns.iterator();
        while (iterator.hasNext()) {
            pattern = ShortTypeHandling.castToString((Object)iterator.next());
            String syntaxAndPattern = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)MATCH_PREFIX, (CharSequence)"**"), (CharSequence)File.separator), (CharSequence)pattern);
            if (IS_OS_WINDOWS) {
                String string;
                syntaxAndPattern = string = syntaxAndPattern.replace("\\", "\\\\");
            }
            pathMatchers.add(fileSystem.getPathMatcher(syntaxAndPattern));
        }
        return pathMatchers;
    }

    @Deprecated
    public ListMultimap<Path, ContractMetadata> findContracts() {
        Reference contracts = new Reference(this.findContractsRecursively());
        return new ListMultimap<Path, ContractMetadata>(this, contracts){
            public /* synthetic */ Reference contracts;
            public /* synthetic */ ContractFileScanner this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                ContractFileScanner contractFileScanner;
                this.this$0 = contractFileScanner = p0;
                this.contracts = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public List<ContractMetadata> get(Path key) {
                return (List)ScriptBytecodeAdapter.castToType(((MultiValueMap)this.contracts.get()).get(key), List.class);
            }

            public List<ContractMetadata> removeAll(Object key) {
                return (List)ScriptBytecodeAdapter.castToType(((MultiValueMap)this.contracts.get()).remove(key), List.class);
            }

            public List<ContractMetadata> replaceValues(Path key, Iterable<? extends ContractMetadata> values) {
                return (List)ScriptBytecodeAdapter.castToType(((MultiValueMap)this.contracts.get()).put(key, 1.asList(values)), List.class);
            }

            private static List<? extends ContractMetadata> asList(Iterable<? extends ContractMetadata> self) {
                if (self instanceof List) {
                    return (List)ScriptBytecodeAdapter.castToType(self, List.class);
                }
                return 1.toList(self.iterator());
            }

            private static List<? extends ContractMetadata> toList(Iterator<? extends ContractMetadata> self) {
                ArrayList<ContractMetadata> answer = new ArrayList<ContractMetadata>();
                while (self.hasNext()) {
                    answer.add(self.next());
                }
                return answer;
            }

            public Map<Path, Collection<ContractMetadata>> asMap() {
                public final class _asMap_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _asMap_closure1(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{((Map.Entry)it).getKey(), (Collection)((Map.Entry)it).getValue()});
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _asMap_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.collectEntries((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.contracts.get(), Map.class)), (Closure)new _asMap_closure1(this, this));
            }

            public int size() {
                return ((MultiValueMap)this.contracts.get()).size();
            }

            public boolean isEmpty() {
                return ((MultiValueMap)this.contracts.get()).isEmpty();
            }

            public boolean containsKey(Object key) {
                return ((MultiValueMap)this.contracts.get()).containsKey(key);
            }

            public boolean containsValue(Object value) {
                Reference value2 = new Reference(value);
                public final class _containsValue_closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference value;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _containsValue_closure2(Object _outerInstance, Object _thisObject, Reference value) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.value = reference = value;
                    }

                    public Object doCall(Object it) {
                        return ((List)((Map.Entry)it).getValue()).contains(this.value.get());
                    }

                    @Generated
                    public Object getValue() {
                        return this.value.get();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _containsValue_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.findResult((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.contracts.get(), Map.class)), (Closure)new _containsValue_closure2(this, this, value2)));
            }

            /*
             * WARNING - void declaration
             */
            public boolean containsEntry(Object key, Object value) {
                void var2_2;
                Reference key2 = new Reference(key);
                Reference value2 = new Reference((Object)var2_2);
                public final class _containsEntry_closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference key;
                    private /* synthetic */ Reference value;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _containsEntry_closure3(Object _outerInstance, Object _thisObject, Reference key, Reference value) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.key = reference2 = key;
                        this.value = reference = value;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual(((Map.Entry)it).getKey(), (Object)this.key.get()) && ((List)((Map.Entry)it).getValue()).contains(this.value.get());
                    }

                    @Generated
                    public Object getKey() {
                        return this.key.get();
                    }

                    @Generated
                    public Object getValue() {
                        return this.value.get();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _containsEntry_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.findResult((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.contracts.get(), Map.class)), (Closure)new _containsEntry_closure3(this, this, key2, value2)));
            }

            public boolean put(Path key, ContractMetadata value) {
                ((MultiValueMap)this.contracts.get()).add((Object)key, (Object)value);
                return DefaultTypeTransformation.booleanUnbox(null);
            }

            public boolean remove(Object key, Object value) {
                return ((List)((MultiValueMap)this.contracts.get()).getOrDefault(key, new ArrayList())).remove(value);
            }

            public boolean putAll(Path key, Iterable<? extends ContractMetadata> values) {
                return DefaultGroovyMethods.addAll((Collection)((Collection)ScriptBytecodeAdapter.castToType(((MultiValueMap)this.contracts.get()).getOrDefault(key, new ArrayList()), Collection.class)), values);
            }

            public boolean putAll(Multimap<? extends Path, ? extends ContractMetadata> multimap) {
                public final class _putAll_closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference contracts;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _putAll_closure4(Object _outerInstance, Object _thisObject, Reference contracts) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.contracts = reference = contracts;
                    }

                    public Object doCall(Object it) {
                        ((MultiValueMap)this.contracts.get()).add(((Map.Entry)it).getKey(), ((Map.Entry)it).getValue());
                        return null;
                    }

                    @Generated
                    public MultiValueMap getContracts() {
                        return (MultiValueMap)ScriptBytecodeAdapter.castToType((Object)this.contracts.get(), MultiValueMap.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _putAll_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.each((Collection)multimap.entries(), (Closure)new _putAll_closure4(this, this, this.contracts));
                return true;
            }

            public void clear() {
                ((MultiValueMap)this.contracts.get()).clear();
            }

            public Set<Path> keySet() {
                return ((MultiValueMap)this.contracts.get()).keySet();
            }

            public Multiset<Path> keys() {
                return HashMultiset.create(((MultiValueMap)this.contracts.get()).keySet());
            }

            public Collection<ContractMetadata> values() {
                return DefaultGroovyMethods.flatten(((MultiValueMap)this.contracts.get()).values());
            }

            public Collection<Map.Entry<Path, ContractMetadata>> entries() {
                Reference entries = new Reference(new LinkedList());
                public final class _entries_closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference entries;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _entries_closure5(Object _outerInstance, Object _thisObject, Reference entries) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.entries = reference = entries;
                    }

                    public Object doCall(Object it) {
                        Reference path = new Reference((Object)((Path)ScriptBytecodeAdapter.castToType(((Map.Entry)it).getKey(), Path.class)));
                        List list = (List)ScriptBytecodeAdapter.castToType(((Map.Entry)it).getValue(), List.class);
                        public final class _closure6
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference entries;
                            private /* synthetic */ Reference path;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure6(Object _outerInstance, Object _thisObject, Reference entries, Reference path) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                this.entries = reference2 = entries;
                                this.path = reference = path;
                            }

                            public Object doCall(Object it) {
                                return ((LinkedList)this.entries.get()).add(new AbstractMap.SimpleEntry<Object, Object>(this.path.get(), it));
                            }

                            @Generated
                            public Collection getEntries() {
                                return (Collection)ScriptBytecodeAdapter.castToType((Object)this.entries.get(), Collection.class);
                            }

                            @Generated
                            public Path getPath() {
                                return (Path)ScriptBytecodeAdapter.castToType((Object)this.path.get(), Path.class);
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure6.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        return DefaultGroovyMethods.each((List)list, (Closure)new _closure6((Object)this, this.getThisObject(), this.entries, path));
                    }

                    @Generated
                    public Collection getEntries() {
                        return (Collection)ScriptBytecodeAdapter.castToType((Object)this.entries.get(), Collection.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _entries_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.each((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.contracts.get(), Map.class)), (Closure)new _entries_closure5(this, this, entries));
                return (LinkedList)entries.get();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ContractFileScanner.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ContractFileScanner.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, ContractFileScanner.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        };
    }

    public MultiValueMap<Path, ContractMetadata> findContractsRecursively() {
        MultiValueMap result = CollectionUtils.toMultiValueMap(new LinkedHashMap());
        this.appendRecursively(this.baseDir, (MultiValueMap<Path, ContractMetadata>)result);
        return result;
    }

    private void appendRecursively(File baseDir, MultiValueMap<Path, ContractMetadata> result) {
        List<ContractConverter> converters = this.convertersWithYml();
        if (log.isTraceEnabled()) {
            Object v0;
            if (log.isTraceEnabled()) {
                log.trace((Object)new GStringImpl(new Object[]{converters}, new String[]{"Found the following contract converters ", ""}));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        File[] files = baseDir.listFiles();
        if (!DefaultTypeTransformation.booleanUnbox((Object)files)) {
            return;
        }
        Object[] sortedFiles = (File[])DefaultGroovyMethods.sort((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)files, Object[].class)));
        int i = 0;
        while (i < sortedFiles.length) {
            File file = (File)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])sortedFiles, (int)i), File.class);
            boolean excluded = this.matchesPattern(file, this.excludeMatchers);
            if (!excluded) {
                boolean bl;
                boolean contractFile = this.isContractFile(file);
                boolean included = DefaultTypeTransformation.booleanUnbox((Object)this.includeMatcher) ? file.getAbsolutePath().matches(this.includeMatcher) : true;
                included = bl = DefaultTypeTransformation.booleanUnbox(this.includeMatchers) ? this.matchesPattern(file, this.includeMatchers) : included;
                if (contractFile && included) {
                    this.addContractToTestGeneration(result, files, file, i, ContractVerifierDslConverter.convertAsCollection(baseDir, file));
                }
                if (!contractFile && included) {
                    this.addContractToTestGeneration(converters, result, files, file, i);
                } else {
                    this.appendRecursively(file, result);
                    if (log.isDebugEnabled()) {
                        Object v1;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)new GStringImpl(new Object[]{file, contractFile, included}, new String[]{"File [", "] is ignored. Is a contract file? [", "]. Should be included by pattern? [", "]"}));
                            v1 = null;
                        } else {
                            v1 = null;
                        }
                    }
                }
            } else if (log.isDebugEnabled()) {
                Object v2;
                if (log.isDebugEnabled()) {
                    log.debug((Object)new GStringImpl(new Object[]{file, excluded}, new String[]{"File [", "] is ignored. Should be excluded? [", "]"}));
                    v2 = null;
                } else {
                    v2 = null;
                }
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
    }

    protected List<ContractConverter> convertersWithYml() {
        List<ContractConverter> converters = this.converters();
        converters.add(ContractVerifierDslConverter.INSTANCE);
        converters.add(YamlContractConverter.INSTANCE);
        return converters;
    }

    protected List<ContractConverter> converters() {
        return SpringFactoriesLoader.loadFactories(ContractConverter.class, null);
    }

    private void addContractToTestGeneration(List<ContractConverter> converters, MultiValueMap<Path, ContractMetadata> result, File[] files, File file, int index) {
        boolean converted = false;
        if (!file.isDirectory()) {
            ContractConverter converter = null;
            Iterator<ContractConverter> iterator = converters.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                converter = (ContractConverter)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ContractConverter.class);
                Collection<Contract> contracts = this.tryConvert(converter, file);
                if (!DefaultTypeTransformation.booleanUnbox(contracts)) continue;
                this.addContractToTestGeneration(result, files, file, index, contracts);
                converted = bl = true;
                break;
            }
        }
        if (!converted) {
            this.appendRecursively(file, result);
            if (log.isDebugEnabled()) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug((Object)new GStringImpl(new Object[]{file, file.isDirectory()}, new String[]{"File [", "] wasn't ignored but no converter was applicable. The file is a directory [", "]"}));
                    v0 = null;
                } else {
                    v0 = null;
                }
            }
        }
    }

    private Collection<Contract> tryConvert(ContractConverter converter, File file) {
        boolean accepted = converter.isAccepted(file);
        if (!accepted) {
            return (Collection)ScriptBytecodeAdapter.castToType(null, Collection.class);
        }
        Collection collection = converter.convertFrom(file);
        try {
            return collection;
        }
        catch (Exception e) {
            throw (Throwable)new IllegalStateException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Failed to convert file [", (Object)file), (CharSequence)"]"), e);
        }
    }

    private void addContractToTestGeneration(MultiValueMap<Path, ContractMetadata> result, File[] files, File file, int index, Collection<Contract> convertedContract) {
        Path path = file.toPath();
        Integer order = null;
        if (this.hasScenarioFilenamePattern(path)) {
            int n = index;
            order = n;
        }
        Path parent = file.getParentFile().toPath();
        ContractMetadata metadata = new ContractMetadata(path, this.matchesPattern(file, this.ignoreMatchers), DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)files, Object[].class))), order, convertedContract);
        if (log.isDebugEnabled()) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Creating a contract entry for path [", (Object)path), (CharSequence)"] and metadata ["), (Object)metadata), (CharSequence)"]"));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        result.add((Object)parent, (Object)metadata);
    }

    private boolean hasScenarioFilenamePattern(Path path) {
        return SCENARIO_STEP_FILENAME_PATTERN.matcher(path.getFileName().toString()).matches();
    }

    private boolean matchesPattern(File file, Set<PathMatcher> matchers) {
        PathMatcher matcher = null;
        Iterator<PathMatcher> iterator = matchers.iterator();
        while (iterator.hasNext()) {
            Object v0;
            matcher = (PathMatcher)ScriptBytecodeAdapter.castToType((Object)iterator.next(), PathMatcher.class);
            if (matcher.matches(file.toPath())) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)new GStringImpl(new Object[]{file.toPath(), matcher}, new String[]{"Path [", "] doesn't match the pattern [", "]"}));
                v0 = null;
                continue;
            }
            v0 = null;
        }
        return false;
    }

    private boolean isContractFile(File file) {
        return file.isFile() && ContractVerifierDslConverter.INSTANCE.isAccepted(file);
    }

    private static boolean getOSMatchesName(String osNamePrefix) {
        return ContractFileScanner.isOSNameMatch(OS_NAME, osNamePrefix);
    }

    private static boolean isOSNameMatch(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.startsWith(osNamePrefix);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ContractFileScanner.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ContractFileScanner.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ContractFileScanner.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ContractFileScanner.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        Pattern pattern;
        boolean bl;
        String string;
        OS_NAME = string = System.getProperty("os.name");
        IS_OS_WINDOWS = bl = ContractFileScanner.getOSMatchesName(OS_NAME_WINDOWS_PREFIX);
        SCENARIO_STEP_FILENAME_PATTERN = pattern = Pattern.compile("[0-9]+_.*");
        ContractFileScanner.log = log = LogFactory.getLog((String)"org.springframework.cloud.contract.verifier.file.ContractFileScanner");
    }
}

