/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ClassPresenceChecker {
    private static final Log log = LogFactory.getLog(ClassPresenceChecker.class);

    ClassPresenceChecker() {
    }

    boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("[" + className + "] is not present on classpath"));
            }
            return false;
        }
    }
}

