/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util.xml;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.wst.xml.xpath2.processor.util.StaticContextBuilder;
import org.w3c.dom.Document;

class XmlCachedObjects {
    final Document document;
    final StaticContextBuilder xpathBuilder;
    final String xmlAsString;

    XmlCachedObjects(Document document) {
        this.document = document;
        this.xpathBuilder = new StaticContextBuilder();
        this.xmlAsString = this.xmlAsString();
    }

    XmlCachedObjects(Document document, String xmlAsString) {
        this.document = document;
        this.xpathBuilder = new StaticContextBuilder();
        this.xmlAsString = xmlAsString;
    }

    private String xmlAsString() {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(this.document), new StreamResult(writer));
            return writer.getBuffer().toString().replaceAll("\n|\r", "");
        }
        catch (TransformerException e) {
            throw new RuntimeException("Exception occured while trying to convert XML Document to String", e);
        }
    }
}

