/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.camel;

import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.camel.CamelStubMessages;
import org.springframework.cloud.contract.verifier.messaging.camel.ContractVerifierCamelHelper;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpContractVerifierAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Message.class})
@AutoConfigureBefore(value={NoOpContractVerifierAutoConfiguration.class})
public class ContractVerifierCamelConfiguration {
    @Bean
    @ConditionalOnMissingBean
    MessageVerifier<Message> contractVerifierMessageExchange(CamelContext context) {
        return new CamelStubMessages(context);
    }

    @Bean
    @ConditionalOnMissingBean
    public ContractVerifierMessaging<Message> contractVerifierMessaging(MessageVerifier<Message> exchange) {
        return new ContractVerifierCamelHelper(exchange);
    }
}

