/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.AvailablePortScanner;
import org.springframework.cloud.contract.stubrunner.HttpServerStub;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubRepository;
import org.springframework.cloud.contract.stubrunner.StubRunnerExecutor;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunning;
import org.springframework.cloud.contract.stubrunner.TemporaryFileStorage;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.StringUtils;

public class StubRunner
implements StubRunning {
    private static final Log log = LogFactory.getLog(StubRunner.class);
    private final StubRepository stubRepository;
    private final StubConfiguration stubsConfiguration;
    private final StubRunnerOptions stubRunnerOptions;
    private final StubRunnerExecutor localStubRunner;

    public StubRunner(StubRunnerOptions stubRunnerOptions, String repositoryPath, StubConfiguration stubsConfiguration) {
        this(stubRunnerOptions, repositoryPath, stubsConfiguration, (MessageVerifierSender<?>)new NoOpStubMessages());
    }

    public StubRunner(StubRunnerOptions stubRunnerOptions, String repositoryPath, StubConfiguration stubsConfiguration, MessageVerifierSender<?> contractVerifierMessaging) {
        this.stubsConfiguration = stubsConfiguration;
        this.stubRunnerOptions = stubRunnerOptions;
        List serverStubs = SpringFactoriesLoader.loadFactories(HttpServerStub.class, null);
        this.stubRepository = new StubRepository(new File(repositoryPath), serverStubs, this.stubRunnerOptions, stubsConfiguration);
        AvailablePortScanner portScanner = new AvailablePortScanner(stubRunnerOptions.getMinPortValue(), stubRunnerOptions.getMaxPortValue());
        this.localStubRunner = new StubRunnerExecutor(portScanner, contractVerifierMessaging, serverStubs);
    }

    @Override
    public RunningStubs runStubs() {
        String registeredMappings;
        this.registerShutdownHook();
        RunningStubs stubs = this.localStubRunner.runStubs(this.stubRunnerOptions, this.stubRepository, this.stubsConfiguration);
        if (this.stubRunnerOptions.hasMappingsOutputFolder() && StringUtils.hasText((String)(registeredMappings = this.localStubRunner.registeredMappings()))) {
            File outputMappings = new File(this.stubRunnerOptions.getMappingsOutputFolder(), this.stubsConfiguration.artifactId + "_" + stubs.getPort(this.stubsConfiguration.toColonSeparatedDependencyNotation()));
            try {
                outputMappings.getParentFile().mkdirs();
                this.clearOldFiles(outputMappings.getParentFile(), this.stubsConfiguration.artifactId);
                outputMappings.createNewFile();
                Files.write(Paths.get(outputMappings.toURI()), registeredMappings.getBytes(), new OpenOption[0]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Stored the mappings for artifactid [" + this.stubsConfiguration.artifactId + "] at [" + String.valueOf(outputMappings) + "] location"));
                }
            }
            catch (IOException e) {
                log.error((Object)"Exception occurred while trying to store the mappings", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        return stubs;
    }

    private void clearOldFiles(File outputFolder, final String filename) {
        File[] files = outputFolder.listFiles(new FilenameFilter(){
            final /* synthetic */ StubRunner this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(filename);
            }
        });
        if (files == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to retrieve any mappings");
            }
            return;
        }
        for (File file : files) {
            if (file.delete() || !log.isDebugEnabled()) continue;
            log.debug((Object)("Exception occurred while trying to remove [" + file.getAbsolutePath() + "]"));
        }
    }

    @Override
    public URL findStubUrl(String groupId, String artifactId) {
        return this.localStubRunner.findStubUrl(groupId, artifactId);
    }

    @Override
    public URL findStubUrl(String ivyNotation) {
        return this.localStubRunner.findStubUrl(ivyNotation);
    }

    @Override
    public RunningStubs findAllRunningStubs() {
        return this.localStubRunner.findAllRunningStubs();
    }

    @Override
    public Map<StubConfiguration, Collection<Contract>> getContracts() {
        return this.localStubRunner.getContracts();
    }

    @Override
    public boolean trigger(String ivyNotation, String labelName) {
        return this.localStubRunner.trigger(ivyNotation, labelName);
    }

    @Override
    public boolean trigger(String labelName) {
        return this.localStubRunner.trigger(labelName);
    }

    @Override
    public boolean trigger() {
        return this.localStubRunner.trigger();
    }

    @Override
    public Map<String, Collection<String>> labels() {
        return this.localStubRunner.labels();
    }

    private void registerShutdownHook() {
        Runnable stopAllServers = new Runnable(){

            @Override
            public void run() {
                try {
                    StubRunner.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(stopAllServers));
    }

    @Override
    public void close() throws IOException {
        if (this.localStubRunner != null) {
            this.localStubRunner.shutdown();
        }
        TemporaryFileStorage.cleanup(this.stubRunnerOptions.isDeleteStubsAfterTest());
    }
}

