/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import org.springframework.cloud.contract.stubrunner.HttpServerStubConfigurer;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;

public final class HttpServerStubConfiguration {
    public final HttpServerStubConfigurer configurer;
    public final StubRunnerOptions stubRunnerOptions;
    public final StubConfiguration stubConfiguration;
    public final Integer port;
    public boolean randomPort;

    public HttpServerStubConfiguration(HttpServerStubConfigurer configurer, StubRunnerOptions stubRunnerOptions, StubConfiguration stubConfiguration, Integer port) {
        this(configurer, stubRunnerOptions, stubConfiguration, port, HttpServerStubConfiguration.randomPort(port));
    }

    public HttpServerStubConfiguration(HttpServerStubConfigurer configurer, StubRunnerOptions stubRunnerOptions, StubConfiguration stubConfiguration, Integer port, boolean randomPort) {
        this.configurer = configurer;
        this.stubRunnerOptions = stubRunnerOptions;
        this.stubConfiguration = stubConfiguration;
        this.port = port;
        this.randomPort = randomPort;
    }

    private static boolean randomPort(Integer port) {
        return port == null || port == 0;
    }

    public boolean isRandomPort() {
        return HttpServerStubConfiguration.randomPort(this.port);
    }

    public String toColonSeparatedDependencyNotation() {
        return this.stubConfiguration != null ? this.stubConfiguration.toColonSeparatedDependencyNotation() : "";
    }
}

