/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerPropertyUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

class GitStubDownloaderProperties {
    private static final Log log = LogFactory.getLog(GitStubDownloaderProperties.class);
    private static final String GIT_BRANCH_PROPERTY = "git.branch";
    private static final String GIT_USERNAME_PROPERTY = "git.username";
    private static final String GIT_PASSWORD_PROPERTY = "git.password";
    private static final String GIT_ENSURE_GIT_SUFFIX_PROPERTY = "git.ensure-git-suffix";
    final URI url;
    final String username;
    final String password;
    final String branch;
    final Boolean ensureGitSuffix;

    GitStubDownloaderProperties(Resource repo, StubRunnerOptions options) {
        String repoUrl;
        Map<String, String> args = options.getProperties();
        try {
            repoUrl = this.schemeSpecificPart(repo.getURI());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        String modifiedRepo = repoUrl.startsWith("git@") ? this.modifyUrlForGitRepo(repoUrl) : repoUrl;
        this.url = URI.create(modifiedRepo);
        String username = StubRunnerPropertyUtils.getProperty(args, GIT_USERNAME_PROPERTY);
        this.username = StringUtils.hasText((String)username) ? username : options.getUsername();
        String password = StubRunnerPropertyUtils.getProperty(args, GIT_PASSWORD_PROPERTY);
        this.password = StringUtils.hasText((String)password) ? password : options.getPassword();
        String branch = StubRunnerPropertyUtils.getProperty(args, GIT_BRANCH_PROPERTY);
        this.branch = StringUtils.hasText((String)branch) ? branch : "master";
        String ensureGitSuffix = StubRunnerPropertyUtils.getProperty(args, GIT_ENSURE_GIT_SUFFIX_PROPERTY);
        this.ensureGitSuffix = StringUtils.hasText((String)ensureGitSuffix) ? Boolean.parseBoolean(ensureGitSuffix) : true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Repo url is [" + repoUrl + "], modified url string is [" + modifiedRepo + "] URL is [" + this.url + "]  branch is [" + this.branch + "] and ensureGitSuffix is [" + this.ensureGitSuffix + "]"));
        }
    }

    private String schemeSpecificPart(URI uri) {
        String part = uri.getSchemeSpecificPart();
        if (StringUtils.isEmpty((Object)part)) {
            return part;
        }
        return part.startsWith("//") ? part.substring(2) : part;
    }

    private String modifyUrlForGitRepo(String gitRepo) {
        return "git:" + gitRepo;
    }
}

