/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.stream;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.stubrunner.messaging.stream.StubRunnerStreamMessageSelector;
import org.springframework.cloud.contract.verifier.util.BodyExtractor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

class StubRunnerStreamTransformer {
    private final StubRunnerStreamMessageSelector selector;

    StubRunnerStreamTransformer(Contract groovyDsl) {
        this(Collections.singletonList(groovyDsl));
    }

    StubRunnerStreamTransformer(List<Contract> groovyDsls) {
        this.selector = new StubRunnerStreamMessageSelector(groovyDsls);
    }

    public Message<?> transform(Message<?> source) {
        Contract groovyDsl = this.matchingContract(source);
        if (groovyDsl == null || groovyDsl.getOutputMessage() == null) {
            return source;
        }
        byte[] outputBody = this.outputBodyAsBytes(groovyDsl);
        Map headers = groovyDsl.getOutputMessage().getHeaders().asStubSideMap();
        MessageHeaders messageHeaders = new MessageHeaders(headers);
        Message message = MessageBuilder.createMessage((Object)outputBody, (MessageHeaders)messageHeaders);
        this.selector.updateCache(message, groovyDsl);
        return message;
    }

    private byte[] outputBodyAsBytes(Contract groovyDsl) {
        Object outputBody = BodyExtractor.extractClientValueFromBody((Object)groovyDsl.getOutputMessage().getBody());
        if (outputBody instanceof FromFileProperty) {
            FromFileProperty property = (FromFileProperty)outputBody;
            return property.asBytes();
        }
        return BodyExtractor.extractStubValueFrom((Object)outputBody).getBytes();
    }

    Contract matchingContract(Message<?> source) {
        return this.selector.matchingContract(source);
    }
}

