/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import groovy.json.JsonOutput;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.OutputMessage;
import org.springframework.cloud.contract.stubrunner.AvailablePortScanner;
import org.springframework.cloud.contract.stubrunner.HttpServerStub;
import org.springframework.cloud.contract.stubrunner.HttpServerStubConfiguration;
import org.springframework.cloud.contract.stubrunner.HttpServerStubConfigurer;
import org.springframework.cloud.contract.stubrunner.NoOpHttpServerStub;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.StubNotFoundException;
import org.springframework.cloud.contract.stubrunner.StubRepository;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubServer;
import org.springframework.cloud.contract.stubrunner.provider.wiremock.WireMockHttpServerStub;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;
import org.springframework.cloud.contract.verifier.util.BodyExtractor;
import wiremock.org.eclipse.jetty.util.ConcurrentHashSet;

class StubRunnerExecutor
implements StubFinder {
    static final Set<StubServer> STUB_SERVERS = new ConcurrentHashSet();
    private static final Log log = LogFactory.getLog(StubRunnerExecutor.class);
    private final AvailablePortScanner portScanner;
    private final MessageVerifier<?> contractVerifierMessaging;
    private final List<HttpServerStub> serverStubs;
    private StubServer stubServer;

    StubRunnerExecutor(AvailablePortScanner portScanner, MessageVerifier<?> contractVerifierMessaging, List<HttpServerStub> serverStubs) {
        this.portScanner = portScanner;
        this.contractVerifierMessaging = contractVerifierMessaging;
        this.serverStubs = serverStubs;
    }

    StubRunnerExecutor(AvailablePortScanner portScanner, List<HttpServerStub> serverStubs) {
        this(portScanner, (MessageVerifier<?>)new NoOpStubMessages(), serverStubs);
    }

    StubRunnerExecutor(AvailablePortScanner portScanner) {
        this(portScanner, (MessageVerifier<?>)new NoOpStubMessages(), (List<HttpServerStub>)new ArrayList<HttpServerStub>());
    }

    public RunningStubs runStubs(StubRunnerOptions stubRunnerOptions, StubRepository repository, StubConfiguration stubConfiguration) {
        if (this.stubServer != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning cached version of stubs [" + stubConfiguration.toColonSeparatedDependencyNotation() + "]"));
            }
            return this.runningStubs();
        }
        try {
            HttpServerStubConfigurer configurer = stubRunnerOptions.getHttpServerStubConfigurer().newInstance();
            this.startStubServers(configurer, stubRunnerOptions, stubConfiguration, repository);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            log.error((Object)"Failed to instantiate the HTTP stub configurer", (Throwable)ex);
        }
        RunningStubs runningCollaborators = this.runningStubs();
        log.info((Object)("All stubs are now running " + runningCollaborators.toString()));
        return runningCollaborators;
    }

    private RunningStubs runningStubs() {
        return new RunningStubs(Collections.singletonMap(this.stubServer.getStubConfiguration(), this.stubServer.getPort()));
    }

    public void shutdown() {
        if (this.stubServer != null) {
            this.stubServer.stop();
        }
    }

    String registeredMappings() {
        return this.stubServer.registeredMappings();
    }

    @Override
    public URL findStubUrl(String groupId, String artifactId) {
        URL url = null;
        if (groupId == null) {
            url = this.findStubUrl(this.stubServer.stubConfiguration.artifactId.equals(artifactId));
        }
        if (url == null) {
            url = this.findStubUrl(this.stubServer.stubConfiguration.artifactId.equals(artifactId) && this.stubServer.stubConfiguration.groupId.equals(groupId));
        }
        if (url == null) {
            throw new StubNotFoundException(groupId, artifactId);
        }
        return url;
    }

    @Override
    public URL findStubUrl(String ivyNotation) {
        String[] splitString = ivyNotation.split(":", -1);
        if (splitString.length > 4) {
            throw new IllegalArgumentException("[" + ivyNotation + "] is an invalid notation. Pass [groupId]:artifactId[:version][:classifier].");
        }
        if (splitString.length == 1) {
            return this.findStubUrl(null, splitString[0]);
        }
        if (splitString.length == 2) {
            return this.findStubUrl(splitString[0], splitString[1]);
        }
        if (splitString.length == 3) {
            return this.findStubUrl(this.groupIdArtifactVersionMatches(splitString));
        }
        return this.findStubUrl(this.groupIdArtifactVersionMatches(splitString) && this.classifierMatches(splitString));
    }

    private boolean classifierMatches(String[] splitString) {
        return this.stubServer.stubConfiguration.classifier.equals(splitString[3]);
    }

    private boolean groupIdArtifactVersionMatches(String[] splitString) {
        return this.stubServer.stubConfiguration.groupId.equals(splitString[0]) && this.stubServer.stubConfiguration.artifactId.equals(splitString[1]) && this.stubServer.stubConfiguration.version.equals(splitString[2]);
    }

    private URL findStubUrl(boolean condition) {
        return this.returnStubUrlIfMatches(condition);
    }

    @Override
    public RunningStubs findAllRunningStubs() {
        return new RunningStubs(Collections.singletonMap(this.stubServer.stubConfiguration, this.stubServer.getPort()));
    }

    @Override
    public Map<StubConfiguration, Collection<Contract>> getContracts() {
        return Collections.singletonMap(this.stubServer.stubConfiguration, this.stubServer.getContracts());
    }

    @Override
    public boolean trigger(String ivyNotationAsString, String labelName) {
        ArrayList<Contract> matchingContracts = new ArrayList<Contract>();
        for (Map.Entry<StubConfiguration, Collection<Contract>> it : this.getContracts().entrySet()) {
            if (!it.getKey().groupIdAndArtifactMatches(ivyNotationAsString)) continue;
            matchingContracts.addAll(it.getValue());
        }
        return this.triggerForDsls(matchingContracts, labelName);
    }

    @Override
    public boolean trigger(String labelName) {
        ArrayList<Contract> matchingContracts = new ArrayList<Contract>();
        for (Collection<Contract> it : this.getContracts().values()) {
            matchingContracts.addAll(it);
        }
        return this.triggerForDsls(matchingContracts, labelName);
    }

    private boolean triggerForDsls(Collection<Contract> dsls, String labelName) {
        ArrayList<Contract> matchingDsls = new ArrayList<Contract>();
        for (Contract contract : dsls) {
            if (!labelName.equals(contract.getLabel()) || contract.getOutputMessage() == null) continue;
            matchingDsls.add(contract);
        }
        if (matchingDsls.isEmpty()) {
            return false;
        }
        for (Contract contract : matchingDsls) {
            this.sendMessage(contract);
        }
        return true;
    }

    @Override
    public boolean trigger() {
        ArrayList<Contract> matchingContracts = new ArrayList<Contract>();
        for (Collection<Contract> it : this.getContracts().values()) {
            for (Contract contract : it) {
                if (contract.getOutputMessage() == null) continue;
                matchingContracts.add(contract);
            }
        }
        if (matchingContracts.isEmpty()) {
            return false;
        }
        for (Contract contract : matchingContracts) {
            this.sendMessage(contract);
        }
        return true;
    }

    @Override
    public Map<String, Collection<String>> labels() {
        LinkedHashMap<String, Collection<String>> labels = new LinkedHashMap<String, Collection<String>>();
        for (Map.Entry<StubConfiguration, Collection<Contract>> it : this.getContracts().entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            for (Contract contract : it.getValue()) {
                if (contract.getLabel() == null) continue;
                values.add(contract.getLabel());
            }
            labels.put(it.getKey().toColonSeparatedDependencyNotation(), values);
        }
        return labels;
    }

    private void sendMessage(Contract groovyDsl) {
        OutputMessage outputMessage = groovyDsl.getOutputMessage();
        DslProperty body = outputMessage.getBody();
        Headers headers = outputMessage.getHeaders();
        this.contractVerifierMessaging.send((Object)JsonOutput.toJson((Object)BodyExtractor.extractClientValueFromBody((Object)(body == null ? null : body.getClientValue()))), headers == null ? null : headers.asStubSideMap(), (String)outputMessage.getSentTo().getClientValue());
    }

    private URL returnStubUrlIfMatches(boolean condition) {
        return condition ? this.stubServer.getStubUrl() : null;
    }

    private StubServer startStubServers(final HttpServerStubConfigurer configurer, final StubRunnerOptions stubRunnerOptions, final StubConfiguration stubConfiguration, StubRepository repository) {
        final List<File> mappings = repository.getStubs();
        final Collection<Contract> contracts = repository.contracts;
        Integer port = stubRunnerOptions.port(stubConfiguration);
        boolean randomPort = this.randomPort(port);
        HttpServerStubConfiguration configuration = new HttpServerStubConfiguration(configurer, stubRunnerOptions, stubConfiguration, port, randomPort);
        if (!this.hasRequest(contracts) && mappings.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"There are no HTTP related contracts. Won't start any servers");
            }
            this.stubServer = new StubServer(stubConfiguration, mappings, contracts, new NoOpHttpServerStub()).start(configuration);
            return this.stubServer;
        }
        this.stubServer = !randomPort ? new StubServer(stubConfiguration, mappings, contracts, this.httpServerStub()).start(configuration) : this.portScanner.tryToExecuteWithFreePort(new AvailablePortScanner.PortCallback<StubServer>(){

            @Override
            public StubServer call(int availablePort) {
                return new StubServer(stubConfiguration, mappings, contracts, StubRunnerExecutor.this.httpServerStub()).start(new HttpServerStubConfiguration(configurer, stubRunnerOptions, stubConfiguration, availablePort, true));
            }
        });
        STUB_SERVERS.add(this.stubServer);
        return this.stubServer;
    }

    private boolean randomPort(Integer port) {
        return port == null || port == 0;
    }

    private boolean hasRequest(Collection<Contract> contracts) {
        if (contracts.isEmpty()) {
            return false;
        }
        for (Contract contract : contracts) {
            if (contract.getRequest() == null) continue;
            return true;
        }
        return false;
    }

    private HttpServerStub httpServerStub() {
        if (this.serverStubs.isEmpty()) {
            return new WireMockHttpServerStub();
        }
        return this.serverStubs.get(0);
    }
}

