/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.camel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.toomuchcoding.jsonassert.JsonAssertion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.BodyMatcher;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.stubrunner.messaging.camel.StubRunnerCamelPayload;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierObjectMapper;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.cloud.contract.verifier.util.ContentUtils;
import org.springframework.cloud.contract.verifier.util.JsonPaths;
import org.springframework.cloud.contract.verifier.util.JsonToJsonPathsConverter;
import org.springframework.cloud.contract.verifier.util.MapConverter;
import org.springframework.cloud.contract.verifier.util.MethodBufferingJsonVerifiable;

class StubRunnerCamelPredicate
implements Predicate {
    private static final Log log = LogFactory.getLog(StubRunnerCamelPredicate.class);
    private final List<Contract> groovyDsls;
    private final ContractVerifierObjectMapper objectMapper = new ContractVerifierObjectMapper();

    StubRunnerCamelPredicate(List<Contract> groovyDsls) {
        this.groovyDsls = groovyDsls;
    }

    public boolean matches(Exchange exchange) {
        Contract contract = this.getContract(exchange.getMessage());
        if (log.isDebugEnabled()) {
            log.debug((Object)("For exchange [" + exchange + "] found contract [" + contract + "]"));
        }
        if (contract == null) {
            return false;
        }
        exchange.getIn().setBody((Object)new StubRunnerCamelPayload(contract));
        return true;
    }

    private Contract getContract(Message message) {
        for (Contract groovyDsl : this.groovyDsls) {
            Contract contract = this.matchContract(message, groovyDsl);
            if (contract == null) continue;
            return contract;
        }
        return null;
    }

    private Contract matchContract(Message message, Contract groovyDsl) {
        List<String> unmatchedHeaders = this.headersMatch(message, groovyDsl);
        if (!unmatchedHeaders.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Contract [" + groovyDsl + "] hasn't matched the following headers " + unmatchedHeaders));
            }
            return null;
        }
        Object inputMessage = message.getBody();
        Object dslBody = MapConverter.getStubSideValues((Object)groovyDsl.getInput().getMessageBody());
        if (dslBody instanceof FromFileProperty) {
            FromFileProperty property;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will compare file content");
            }
            if ((property = (FromFileProperty)dslBody).isString()) {
                dslBody = property.asString();
            } else {
                if (!(inputMessage instanceof byte[])) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Contract provided byte comparison, but the input message is of type [" + inputMessage.getClass() + "]. Can't compare the two."));
                    }
                    return null;
                }
                boolean matches = Arrays.equals(property.asBytes(), (byte[])inputMessage);
                if (log.isDebugEnabled() && !matches) {
                    log.debug((Object)"Contract provided byte comparison, but the byte arrays don't match");
                }
                return matches ? groovyDsl : null;
            }
        }
        if (this.matchViaContent(groovyDsl, inputMessage, dslBody)) {
            return groovyDsl;
        }
        return null;
    }

    private boolean matchViaContent(Contract groovyDsl, Object inputMessage, Object dslBody) {
        boolean matches;
        ContentType type = ContentUtils.getClientContentType((Object)inputMessage, (Headers)groovyDsl.getInput().getMessageHeaders());
        if (type == ContentType.JSON) {
            BodyMatchers matchers = groovyDsl.getInput().getBodyMatchers();
            matches = this.matchesForJsonPayload(groovyDsl, inputMessage, matchers, dslBody);
        } else if (dslBody instanceof RegexProperty && inputMessage instanceof String) {
            Pattern pattern = ((RegexProperty)dslBody).getPattern();
            matches = pattern.matcher((String)inputMessage).matches();
            this.bodyUnmatchedLog(dslBody, matches, pattern);
        } else {
            matches = dslBody.equals(inputMessage);
            this.bodyUnmatchedLog(dslBody, matches, inputMessage);
        }
        return matches;
    }

    private void bodyUnmatchedLog(Object dslBody, boolean matches, Object pattern) {
        if (log.isDebugEnabled() && !matches) {
            log.debug((Object)("Body was supposed to " + this.unmatchedText(pattern) + " but the value is [" + dslBody.toString() + "]"));
        }
    }

    private boolean matchesForJsonPayload(Contract groovyDsl, Object inputMessage, BodyMatchers matchers, Object dslBody) {
        DocumentContext parsedJson;
        Object matchingInputMessage = JsonToJsonPathsConverter.removeMatchingJsonPaths((Object)dslBody, (BodyMatchers)matchers);
        JsonPaths jsonPaths = JsonToJsonPathsConverter.transformToJsonPathWithStubsSideValuesAndNoArraySizeCheck((Object)matchingInputMessage);
        try {
            parsedJson = JsonPath.parse((String)this.objectMapper.writeValueAsString(inputMessage));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot serialize to JSON", e);
        }
        ArrayList<String> unmatchedJsonPath = new ArrayList<String>();
        boolean matches = true;
        for (MethodBufferingJsonVerifiable path : jsonPaths) {
            matches &= this.matchesJsonPath(unmatchedJsonPath, parsedJson, path.jsonPath());
        }
        if (matchers != null && matchers.hasMatchers()) {
            for (BodyMatcher matcher : matchers.matchers()) {
                String jsonPath = JsonToJsonPathsConverter.convertJsonPathAndRegexToAJsonPath((BodyMatcher)matcher, (Object)dslBody);
                matches &= this.matchesJsonPath(unmatchedJsonPath, parsedJson, jsonPath);
            }
        }
        if (!unmatchedJsonPath.isEmpty() && log.isDebugEnabled()) {
            log.debug((Object)("Contract [" + groovyDsl + "] didn't match the body due to " + unmatchedJsonPath));
        }
        return matches;
    }

    private boolean matchesJsonPath(List<String> unmatchedJsonPath, DocumentContext parsedJson, String jsonPath) {
        try {
            JsonAssertion.assertThat((DocumentContext)parsedJson).matchesJsonPath(jsonPath);
            return true;
        }
        catch (Exception e) {
            unmatchedJsonPath.add(e.getLocalizedMessage());
            return false;
        }
    }

    private List<String> headersMatch(Message message, Contract groovyDsl) {
        ArrayList<String> unmatchedHeaders = new ArrayList<String>();
        Map headers = message.getHeaders();
        for (Header it : groovyDsl.getInput().getMessageHeaders().getEntries()) {
            boolean matches;
            String name = it.getName();
            Object value = it.getClientValue();
            Object valueInHeader = headers.get(name);
            if (value instanceof RegexProperty) {
                Pattern pattern = ((RegexProperty)value).getPattern();
                matches = pattern.matcher(valueInHeader.toString()).matches();
            } else {
                boolean bl = matches = valueInHeader != null && valueInHeader.toString().equals(value.toString());
            }
            if (matches) continue;
            unmatchedHeaders.add("Header with name [" + name + "] was supposed to " + this.unmatchedText(value) + " but the value is [" + (valueInHeader != null ? valueInHeader.toString() : "null") + "]");
        }
        return unmatchedHeaders;
    }

    private String unmatchedText(Object expectedValue) {
        return expectedValue instanceof RegexProperty ? "match pattern [" + ((RegexProperty)expectedValue).pattern() + "]" : "be equal to [" + expectedValue + "]";
    }
}

