/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.toomuchcoding.jsonassert.JsonAssertion;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.BodyMatcher;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierObjectMapper;
import org.springframework.cloud.contract.verifier.util.JsonPaths;
import org.springframework.cloud.contract.verifier.util.JsonToJsonPathsConverter;
import org.springframework.cloud.contract.verifier.util.MapConverter;
import org.springframework.cloud.contract.verifier.util.MethodBufferingJsonVerifiable;
import org.springframework.integration.core.MessageSelector;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

class StubRunnerStreamMessageSelector
implements MessageSelector {
    private static final Log log = LogFactory.getLog(StubRunnerStreamMessageSelector.class);
    private final Contract groovyDsl;
    private final ContractVerifierObjectMapper objectMapper = new ContractVerifierObjectMapper();

    StubRunnerStreamMessageSelector(Contract groovyDsl) {
        this.groovyDsl = groovyDsl;
    }

    public boolean accept(Message<?> message) {
        DocumentContext parsedJson;
        List<String> unmatchedHeaders = this.headersMatch(message);
        if (!unmatchedHeaders.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Contract [" + this.groovyDsl + "] hasn't matched the following headers " + unmatchedHeaders));
            }
            return false;
        }
        Object inputMessage = message.getPayload();
        BodyMatchers matchers = this.groovyDsl.getInput().getMatchers();
        Object dslBody = MapConverter.getStubSideValues((Object)this.groovyDsl.getInput().getMessageBody());
        Object matchingInputMessage = JsonToJsonPathsConverter.removeMatchingJsonPaths((Object)dslBody, (BodyMatchers)matchers);
        JsonPaths jsonPaths = JsonToJsonPathsConverter.transformToJsonPathWithStubsSideValuesAndNoArraySizeCheck((Object)matchingInputMessage);
        try {
            parsedJson = JsonPath.parse((String)this.objectMapper.writeValueAsString(inputMessage));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot serialize to JSON", e);
        }
        ArrayList<String> unmatchedJsonPath = new ArrayList<String>();
        boolean matches = true;
        for (MethodBufferingJsonVerifiable path : jsonPaths) {
            matches &= this.matchesJsonPath(unmatchedJsonPath, parsedJson, path.jsonPath());
        }
        if (matchers != null && matchers.hasMatchers()) {
            for (BodyMatcher matcher : matchers.jsonPathMatchers()) {
                String jsonPath = JsonToJsonPathsConverter.convertJsonPathAndRegexToAJsonPath((BodyMatcher)matcher, (Object)dslBody);
                matches &= this.matchesJsonPath(unmatchedJsonPath, parsedJson, jsonPath);
            }
        }
        if (!unmatchedJsonPath.isEmpty() && log.isDebugEnabled()) {
            log.debug((Object)("Contract [" + this.groovyDsl + "] didn't much the body due to " + unmatchedJsonPath));
        }
        return matches;
    }

    private boolean matchesJsonPath(List<String> unmatchedJsonPath, DocumentContext parsedJson, String jsonPath) {
        try {
            JsonAssertion.assertThat((DocumentContext)parsedJson).matchesJsonPath(jsonPath);
            return true;
        }
        catch (Exception e) {
            unmatchedJsonPath.add(e.getLocalizedMessage());
            return false;
        }
    }

    private List<String> headersMatch(Message<?> message) {
        ArrayList<String> unmatchedHeaders = new ArrayList<String>();
        MessageHeaders headers = message.getHeaders();
        for (Header it : this.groovyDsl.getInput().getMessageHeaders().getEntries()) {
            boolean matches;
            String name = it.getName();
            Object value = it.getClientValue();
            Object valueInHeader = headers.get(name);
            if (value instanceof Pattern) {
                Pattern pattern = (Pattern)value;
                matches = pattern.matcher(valueInHeader.toString()).matches();
            } else {
                boolean bl = matches = valueInHeader != null && valueInHeader.toString().equals(value.toString());
            }
            if (matches) continue;
            unmatchedHeaders.add("Header with name [" + name + "] was supposed to " + this.unmatchedText(value) + " but the value is [" + (valueInHeader != null ? valueInHeader.toString() : "null") + "]");
        }
        return unmatchedHeaders;
    }

    private String unmatchedText(Object expectedValue) {
        return expectedValue instanceof Pattern ? "match pattern [" + ((Pattern)expectedValue).pattern() + "]" : "be equal to [" + expectedValue + "]";
    }
}

