/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.ToString;
import java.util.HashSet;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.springframework.cloud.contract.spec.internal.BodyMatcher;
import org.springframework.cloud.contract.spec.internal.JsonPathBodyMatcher;
import org.springframework.cloud.contract.spec.internal.MatchingType;
import org.springframework.cloud.contract.spec.internal.MatchingTypeValue;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;

@ToString(includeFields=true, includePackage=false)
public class BodyMatchers
implements GroovyObject {
    private final RegexPatterns regexPatterns;
    private final List<BodyMatcher> jsonPathRegexMatchers;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public BodyMatchers() {
        MetaClass metaClass;
        List list;
        RegexPatterns regexPatterns;
        this.regexPatterns = regexPatterns = new RegexPatterns();
        this.jsonPathRegexMatchers = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void jsonPath(String path, MatchingTypeValue matchingType) {
        DefaultGroovyMethods.leftShift(this.jsonPathRegexMatchers, (Object)new JsonPathBodyMatcher(path, matchingType));
    }

    public boolean hasMatchers() {
        return !this.jsonPathRegexMatchers.isEmpty();
    }

    public List<BodyMatcher> jsonPathMatchers() {
        return this.jsonPathRegexMatchers;
    }

    public MatchingTypeValue byDate() {
        return new MatchingTypeValue(MatchingType.DATE, this.regexPatterns.isoDate());
    }

    public MatchingTypeValue byTime() {
        return new MatchingTypeValue(MatchingType.TIME, this.regexPatterns.isoTime());
    }

    public MatchingTypeValue byTimestamp() {
        return new MatchingTypeValue(MatchingType.TIMESTAMP, this.regexPatterns.isoDateTime());
    }

    public MatchingTypeValue byRegex(String regex) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = regex;
            valueRecorder.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert regex", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        return new MatchingTypeValue(MatchingType.REGEX, regex);
    }

    public MatchingTypeValue byEquality() {
        return new MatchingTypeValue(MatchingType.EQUALITY, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (ScriptBytecodeAdapter.compareNotEqual(this.getClass(), o.getClass())) {
            return false;
        }
        BodyMatchers that = (BodyMatchers)ScriptBytecodeAdapter.castToType((Object)o, BodyMatchers.class);
        List<BodyMatcher> thisMatchers = this.jsonPathRegexMatchers;
        List<BodyMatcher> thatMatchers = that.jsonPathRegexMatchers;
        if (thisMatchers.size() != thatMatchers.size()) {
            return false;
        }
        return !ScriptBytecodeAdapter.compareNotEqual(new HashSet<BodyMatcher>(thisMatchers), new HashSet<BodyMatcher>(thatMatchers));
    }

    public int hashCode() {
        return this.jsonPathRegexMatchers != null ? this.jsonPathRegexMatchers.hashCode() : 0;
    }

    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("BodyMatchers(");
        Boolean bl = $toStringFirst;
        if (bl == null ? false : bl) {
            Boolean bl2;
            $toStringFirst = bl2 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        if (this.regexPatterns == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.regexPatterns));
        }
        Boolean bl3 = $toStringFirst;
        if (bl3 == null ? false : bl3) {
            Boolean bl4;
            $toStringFirst = bl4 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        if (this.jsonPathRegexMatchers == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString(this.jsonPathRegexMatchers));
        }
        _result.append(")");
        return _result.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BodyMatchers.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

