/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.contract.spec.ContractDslExtensionsKt;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.BodyMatchersDsl;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.Common;
import org.springframework.cloud.contract.spec.internal.CommonDsl;
import org.springframework.cloud.contract.spec.internal.ContractDslMarker;
import org.springframework.cloud.contract.spec.internal.Cookies;
import org.springframework.cloud.contract.spec.internal.CookiesDsl;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.HeadersDsl;
import org.springframework.cloud.contract.spec.internal.HttpMethods;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.Multipart;
import org.springframework.cloud.contract.spec.internal.MultipartDsl;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.spec.internal.ServerDslProperty;
import org.springframework.cloud.contract.spec.internal.Url;
import org.springframework.cloud.contract.spec.internal.UrlPath;
import org.springframework.cloud.contract.spec.util.RegexpUtils;

@ContractDslMarker
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b)\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0004\u0093\u0001\u0094\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010p\u001a\u00020qJ#\u0010r\u001a\u00020\u00172\u0016\u0010s\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050t\"\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010uJ\u000e\u0010@\u001a\u00020A2\u0006\u0010@\u001a\u00020vJ7\u0010@\u001a\u00020A2*\u0010@\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020v0w0t\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020v0w\u00a2\u0006\u0002\u0010xJ\u001a\u0010@\u001a\u00020A2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020v0wJ\u0014\u0010@\u001a\u00020A2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020v0yJ\u001a\u0010@\u001a\u00020A2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020v0zJ\u001f\u0010F\u001a\u00020{2\u0017\u0010|\u001a\u0013\u0012\u0004\u0012\u00020~\u0012\u0004\u0012\u00020{0}\u00a2\u0006\u0002\b\u007fJ\u0010\u0010\u0080\u0001\u001a\u00020q2\u0007\u0010\u0081\u0001\u001a\u00020vJ \u0010L\u001a\u00020{2\u0018\u0010L\u001a\u0014\u0012\u0005\u0012\u00030\u0082\u0001\u0012\u0004\u0012\u00020{0}\u00a2\u0006\u0002\b\u007fJ\u0010\u0010\u0083\u0001\u001a\u00020q2\u0007\u0010\u0081\u0001\u001a\u00020vJ\u0010\u0010\u0084\u0001\u001a\u00020q2\u0007\u0010\u0081\u0001\u001a\u00020vJ\u0010\u0010\u0085\u0001\u001a\u00020q2\u0007\u0010\u0081\u0001\u001a\u00020vJ\u000f\u0010\u0086\u0001\u001a\u00020SH\u0000\u00a2\u0006\u0003\b\u0087\u0001J \u0010T\u001a\u00020{2\u0018\u0010T\u001a\u0014\u0012\u0005\u0012\u00030\u0088\u0001\u0012\u0004\u0012\u00020{0}\u00a2\u0006\u0002\b\u007fJ\u0010\u0010\u0089\u0001\u001a\u00020q2\u0007\u0010\u0081\u0001\u001a\u00020vJ\u0014\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010Z\u001a\u00020\u0005J \u0010^\u001a\u00020{2\u0018\u0010|\u001a\u0014\u0012\u0005\u0012\u00030\u008a\u0001\u0012\u0004\u0012\u00020{0}\u00a2\u0006\u0002\b\u007fJ\u0010\u0010\u008b\u0001\u001a\u00020q2\u0007\u0010\u0081\u0001\u001a\u00020vJ\u0010\u0010\u008c\u0001\u001a\u00020k2\u0007\u0010\u008c\u0001\u001a\u00020\u0005J\u0016\u0010\u008c\u0001\u001a\u00020k2\r\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u0004J\u000e\u0010d\u001a\u00020e2\u0006\u0010d\u001a\u00020\u0005J\u0019\u0010d\u001a\u00020e2\u0007\u0010\u008d\u0001\u001a\u00020\u00172\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001J\u0014\u0010d\u001a\u00020e2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020v0\u0004J\u0017\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\b\u0010\u0081\u0001\u001a\u00030\u0091\u0001J\u0018\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010vJ\u0016\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\u0007\u0010\u0081\u0001\u001a\u00020\u0017J \u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\u0007\u0010\u008d\u0001\u001a\u00020\u00172\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001J\u001c\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\r\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u0004J\u0017\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\b\u0010\u0081\u0001\u001a\u00030\u0092\u0001J \u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u0007\u0010\u008d\u0001\u001a\u00020\u0017J\u0017\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\b\u0010\u0081\u0001\u001a\u00030\u0091\u0001J\u0018\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010vJ\u0016\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\u0007\u0010\u0081\u0001\u001a\u00020\u0017J \u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\u0007\u0010\u008d\u0001\u001a\u00020\u00172\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001J\u001c\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\r\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u0004J\u0017\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\b\u0010\u0081\u0001\u001a\u00030\u0092\u0001J \u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020v0\u00042\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u0007\u0010\u008d\u0001\u001a\u00020\u0017R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u001e\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R\u0011\u0010 \u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0019R\u0011\u0010\"\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019R\u0011\u0010$\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0019R\u0011\u0010&\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0019R\u0011\u0010(\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0019R\u0011\u0010*\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0019R\u0011\u0010,\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0019R\u0011\u0010.\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0019R\u0011\u00100\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0019R\u0011\u00102\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0019R\u0011\u00104\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0019R\u0011\u00106\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0019R\u0011\u00108\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0019R\u0011\u0010:\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0019R\u0011\u0010<\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0019R\u0011\u0010>\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0019R\u001c\u0010@\u001a\u0004\u0018\u00010AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u001c\u0010F\u001a\u0004\u0018\u00010GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u001c\u0010L\u001a\u0004\u0018\u00010MX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u000e\u0010R\u001a\u00020SX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010T\u001a\u0004\u0018\u00010UX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR \u0010Z\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\u0007\"\u0004\b\\\u0010]R\u001c\u0010^\u001a\u0004\u0018\u00010_X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR\u001c\u0010d\u001a\u0004\u0018\u00010eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010g\"\u0004\bh\u0010iR\u001c\u0010j\u001a\u0004\u0018\u00010kX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010m\"\u0004\bn\u0010o\u00a8\u0006\u0095\u0001"}, d2={"Lorg/springframework/cloud/contract/spec/internal/RequestDsl;", "Lorg/springframework/cloud/contract/spec/internal/CommonDsl;", "()V", "DELETE", "Lorg/springframework/cloud/contract/spec/internal/DslProperty;", "", "getDELETE", "()Lorg/springframework/cloud/contract/spec/internal/DslProperty;", "GET", "getGET", "HEAD", "getHEAD", "OPTIONS", "getOPTIONS", "PATCH", "getPATCH", "POST", "getPOST", "PUT", "getPUT", "TRACE", "getTRACE", "aBoolean", "Lorg/springframework/cloud/contract/spec/internal/ClientDslProperty;", "getABoolean", "()Lorg/springframework/cloud/contract/spec/internal/ClientDslProperty;", "anyAlphaNumeric", "getAnyAlphaNumeric", "anyAlphaUnicode", "getAnyAlphaUnicode", "anyDate", "getAnyDate", "anyDateTime", "getAnyDateTime", "anyDouble", "getAnyDouble", "anyEmail", "getAnyEmail", "anyHex", "getAnyHex", "anyHostname", "getAnyHostname", "anyHttpsUrl", "getAnyHttpsUrl", "anyInteger", "getAnyInteger", "anyIpAddress", "getAnyIpAddress", "anyIso8601WithOffset", "getAnyIso8601WithOffset", "anyNonBlankString", "getAnyNonBlankString", "anyNonEmptyString", "getAnyNonEmptyString", "anyNumber", "getAnyNumber", "anyPositiveInt", "getAnyPositiveInt", "anyTime", "getAnyTime", "anyUrl", "getAnyUrl", "anyUuid", "getAnyUuid", "body", "Lorg/springframework/cloud/contract/spec/internal/Body;", "getBody", "()Lorg/springframework/cloud/contract/spec/internal/Body;", "setBody", "(Lorg/springframework/cloud/contract/spec/internal/Body;)V", "bodyMatchers", "Lorg/springframework/cloud/contract/spec/internal/BodyMatchers;", "getBodyMatchers", "()Lorg/springframework/cloud/contract/spec/internal/BodyMatchers;", "setBodyMatchers", "(Lorg/springframework/cloud/contract/spec/internal/BodyMatchers;)V", "cookies", "Lorg/springframework/cloud/contract/spec/internal/Cookies;", "getCookies", "()Lorg/springframework/cloud/contract/spec/internal/Cookies;", "setCookies", "(Lorg/springframework/cloud/contract/spec/internal/Cookies;)V", "delegate", "Lorg/springframework/cloud/contract/spec/internal/Request;", "headers", "Lorg/springframework/cloud/contract/spec/internal/Headers;", "getHeaders", "()Lorg/springframework/cloud/contract/spec/internal/Headers;", "setHeaders", "(Lorg/springframework/cloud/contract/spec/internal/Headers;)V", "method", "getMethod", "setMethod", "(Lorg/springframework/cloud/contract/spec/internal/DslProperty;)V", "multipart", "Lorg/springframework/cloud/contract/spec/internal/Multipart;", "getMultipart", "()Lorg/springframework/cloud/contract/spec/internal/Multipart;", "setMultipart", "(Lorg/springframework/cloud/contract/spec/internal/Multipart;)V", "url", "Lorg/springframework/cloud/contract/spec/internal/Url;", "getUrl", "()Lorg/springframework/cloud/contract/spec/internal/Url;", "setUrl", "(Lorg/springframework/cloud/contract/spec/internal/Url;)V", "urlPath", "Lorg/springframework/cloud/contract/spec/internal/UrlPath;", "getUrlPath", "()Lorg/springframework/cloud/contract/spec/internal/UrlPath;", "setUrlPath", "(Lorg/springframework/cloud/contract/spec/internal/UrlPath;)V", "absent", "Lorg/springframework/cloud/contract/spec/internal/MatchingStrategy;", "anyOf", "values", "", "([Ljava/lang/String;)Lorg/springframework/cloud/contract/spec/internal/ClientDslProperty;", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lorg/springframework/cloud/contract/spec/internal/Body;", "", "", "", "configurer", "Lkotlin/Function1;", "Lorg/springframework/cloud/contract/spec/internal/BodyMatchersDsl;", "Lkotlin/ExtensionFunctionType;", "containing", "value", "Lorg/springframework/cloud/contract/spec/internal/CookiesDsl;", "equalTo", "equalToJson", "equalToXml", "get", "get$spring_cloud_contract_spec_kotlin", "Lorg/springframework/cloud/contract/spec/internal/HeadersDsl;", "matching", "Lorg/springframework/cloud/contract/spec/internal/MultipartDsl;", "notMatching", "path", "client", "server", "Lorg/springframework/cloud/contract/spec/internal/ServerDslProperty;", "v", "Ljava/util/regex/Pattern;", "Lorg/springframework/cloud/contract/spec/internal/RegexProperty;", "RequestCookiesDsl", "RequestHeadersDsl", "spring-cloud-contract-spec-kotlin"})
public class RequestDsl
extends CommonDsl {
    @NotNull
    private final Request delegate = new Request();
    @Nullable
    private DslProperty<?> method;
    @Nullable
    private Url url;
    @Nullable
    private UrlPath urlPath;
    @Nullable
    private Headers headers;
    @Nullable
    private Cookies cookies;
    @Nullable
    private Body body;
    @Nullable
    private Multipart multipart;
    @Nullable
    private BodyMatchers bodyMatchers;

    @Nullable
    public final DslProperty<?> getMethod() {
        return this.method;
    }

    public final void setMethod(@Nullable DslProperty<?> dslProperty) {
        this.method = dslProperty;
    }

    @Nullable
    public final Url getUrl() {
        return this.url;
    }

    public final void setUrl(@Nullable Url url) {
        this.url = url;
    }

    @Nullable
    public final UrlPath getUrlPath() {
        return this.urlPath;
    }

    public final void setUrlPath(@Nullable UrlPath urlPath) {
        this.urlPath = urlPath;
    }

    @Nullable
    public final Headers getHeaders() {
        return this.headers;
    }

    public final void setHeaders(@Nullable Headers headers) {
        this.headers = headers;
    }

    @Nullable
    public final Cookies getCookies() {
        return this.cookies;
    }

    public final void setCookies(@Nullable Cookies cookies) {
        this.cookies = cookies;
    }

    @Nullable
    public final Body getBody() {
        return this.body;
    }

    public final void setBody(@Nullable Body body) {
        this.body = body;
    }

    @Nullable
    public final Multipart getMultipart() {
        return this.multipart;
    }

    public final void setMultipart(@Nullable Multipart multipart) {
        this.multipart = multipart;
    }

    @Nullable
    public final BodyMatchers getBodyMatchers() {
        return this.bodyMatchers;
    }

    public final void setBodyMatchers(@Nullable BodyMatchers bodyMatchers) {
        this.bodyMatchers = bodyMatchers;
    }

    @NotNull
    public final DslProperty<String> method(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return ContractDslExtensionsKt.toDslProperty(method);
    }

    @NotNull
    public final Url url(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new Url((Object)url);
    }

    @NotNull
    public final Url url(@NotNull DslProperty<Object> url) {
        Intrinsics.checkNotNullParameter(url, (String)"url");
        return new Url(url);
    }

    @NotNull
    public final Url url(@NotNull ClientDslProperty client, @NotNull ServerDslProperty server) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return new Url(this.value(client, server));
    }

    @NotNull
    public final UrlPath path(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new UrlPath(path);
    }

    @NotNull
    public final UrlPath path(@NotNull DslProperty<Object> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return new UrlPath(path);
    }

    public final void headers(@NotNull Function1<? super HeadersDsl, Unit> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        RequestHeadersDsl requestHeadersDsl = new RequestHeadersDsl();
        boolean bl = false;
        boolean bl2 = false;
        headers.invoke((Object)requestHeadersDsl);
        this.headers = requestHeadersDsl.get$spring_cloud_contract_spec_kotlin();
    }

    public final void cookies(@NotNull Function1<? super CookiesDsl, Unit> cookies) {
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        RequestCookiesDsl requestCookiesDsl = new RequestCookiesDsl();
        boolean bl = false;
        boolean bl2 = false;
        cookies.invoke((Object)requestCookiesDsl);
        this.cookies = requestCookiesDsl.get$spring_cloud_contract_spec_kotlin();
    }

    @NotNull
    public final Body body(@NotNull Map<String, ? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(body));
    }

    @NotNull
    public final Body body(Pair<String, ? extends Object> ... body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(MapsKt.toMap(body)));
    }

    @NotNull
    public final Body body(@NotNull Pair<String, ? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(MapsKt.mapOf(body)));
    }

    @NotNull
    public final Body body(@NotNull List<? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(body));
    }

    @NotNull
    public final Body body(@NotNull Object body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return new Body(body);
    }

    public final void multipart(@NotNull Function1<? super MultipartDsl, Unit> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        MultipartDsl multipartDsl = new MultipartDsl();
        boolean bl = false;
        boolean bl2 = false;
        configurer.invoke((Object)multipartDsl);
        this.multipart = multipartDsl.get$spring_cloud_contract_spec_kotlin();
    }

    public final void bodyMatchers(@NotNull Function1<? super BodyMatchersDsl, Unit> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        BodyMatchersDsl bodyMatchersDsl = new BodyMatchersDsl();
        boolean bl = false;
        boolean bl2 = false;
        configurer.invoke((Object)bodyMatchersDsl);
        this.bodyMatchers = bodyMatchersDsl.get$spring_cloud_contract_spec_kotlin();
    }

    @NotNull
    public final DslProperty<String> getGET() {
        String string = HttpMethods.GET;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GET");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getHEAD() {
        String string = HttpMethods.HEAD;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HEAD");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getPOST() {
        String string = HttpMethods.POST;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"POST");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getPUT() {
        String string = HttpMethods.PUT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PUT");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getPATCH() {
        String string = HttpMethods.PATCH;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PATCH");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getDELETE() {
        String string = HttpMethods.DELETE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DELETE");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getOPTIONS() {
        String string = HttpMethods.OPTIONS;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"OPTIONS");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getTRACE() {
        String string = HttpMethods.TRACE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TRACE");
        return this.method(string);
    }

    @NotNull
    public final ClientDslProperty getAnyAlphaUnicode() {
        ClientDslProperty clientDslProperty = this.delegate.anyAlphaUnicode();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyAlphaUnicode()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyAlphaNumeric() {
        ClientDslProperty clientDslProperty = this.delegate.anyAlphaNumeric();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyAlphaNumeric()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyNumber() {
        ClientDslProperty clientDslProperty = this.delegate.anyNumber();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyNumber()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyInteger() {
        ClientDslProperty clientDslProperty = this.delegate.anyInteger();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyInteger()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyPositiveInt() {
        ClientDslProperty clientDslProperty = this.delegate.anyPositiveInt();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyPositiveInt()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyDouble() {
        ClientDslProperty clientDslProperty = this.delegate.anyDouble();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyDouble()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyHex() {
        ClientDslProperty clientDslProperty = this.delegate.anyHex();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyHex()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getABoolean() {
        ClientDslProperty clientDslProperty = this.delegate.aBoolean();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.aBoolean()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyIpAddress() {
        ClientDslProperty clientDslProperty = this.delegate.anyIpAddress();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyIpAddress()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyHostname() {
        ClientDslProperty clientDslProperty = this.delegate.anyHostname();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyHostname()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyEmail() {
        ClientDslProperty clientDslProperty = this.delegate.anyEmail();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyEmail()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyUrl() {
        ClientDslProperty clientDslProperty = this.delegate.anyUrl();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyUrl()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyHttpsUrl() {
        ClientDslProperty clientDslProperty = this.delegate.anyHttpsUrl();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyHttpsUrl()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyUuid() {
        ClientDslProperty clientDslProperty = this.delegate.anyUuid();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyUuid()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyDate() {
        ClientDslProperty clientDslProperty = this.delegate.anyDate();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyDate()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyDateTime() {
        ClientDslProperty clientDslProperty = this.delegate.anyDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyDateTime()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyTime() {
        ClientDslProperty clientDslProperty = this.delegate.anyTime();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyTime()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyIso8601WithOffset() {
        ClientDslProperty clientDslProperty = this.delegate.anyIso8601WithOffset();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyIso8601WithOffset()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyNonBlankString() {
        ClientDslProperty clientDslProperty = this.delegate.anyNonBlankString();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyNonBlankString()");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyNonEmptyString() {
        ClientDslProperty clientDslProperty = this.delegate.anyNonEmptyString();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyNonEmptyString()");
        return clientDslProperty;
    }

    @NotNull
    public final MatchingStrategy equalTo(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MatchingStrategy(value, MatchingStrategy.Type.EQUAL_TO);
    }

    @NotNull
    public final MatchingStrategy containing(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MatchingStrategy(value, MatchingStrategy.Type.CONTAINS);
    }

    @NotNull
    public final MatchingStrategy matching(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MatchingStrategy(value, MatchingStrategy.Type.MATCHING);
    }

    @NotNull
    public final MatchingStrategy notMatching(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MatchingStrategy(value, MatchingStrategy.Type.NOT_MATCHING);
    }

    @NotNull
    public final MatchingStrategy equalToXml(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MatchingStrategy(value, MatchingStrategy.Type.EQUAL_TO_XML);
    }

    @NotNull
    public final MatchingStrategy equalToJson(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MatchingStrategy(value, MatchingStrategy.Type.EQUAL_TO_JSON);
    }

    @NotNull
    public final MatchingStrategy absent() {
        return new MatchingStrategy((Object)true, MatchingStrategy.Type.ABSENT);
    }

    @NotNull
    public final DslProperty<Object> value(@NotNull ClientDslProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(value)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@NotNull ClientDslProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(value)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> value(@NotNull DslProperty<Object> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(value)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@NotNull DslProperty<Object> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(value)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> value(@NotNull Pattern value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(value)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@NotNull Pattern value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(value)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> value(@NotNull RegexProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(value)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@NotNull RegexProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(value)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> value(@Nullable Object value) {
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(value)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@Nullable Object value) {
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(value)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> value(@NotNull ClientDslProperty client, @NotNull ServerDslProperty server) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        DslProperty dslProperty = this.delegate.value(client, server);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(client, server)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@NotNull ClientDslProperty client, @NotNull ServerDslProperty server) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        DslProperty dslProperty = this.delegate.value(client, server);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(client, server)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> value(@NotNull ServerDslProperty server, @NotNull ClientDslProperty client) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        DslProperty dslProperty = this.delegate.value(client, server);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(client, server)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@NotNull ServerDslProperty server, @NotNull ClientDslProperty client) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        DslProperty dslProperty = this.delegate.value(client, server);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"delegate.value(client, server)");
        return dslProperty;
    }

    @NotNull
    public final ClientDslProperty anyOf(String ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        ClientDslProperty clientDslProperty = this.delegate.anyOf(Arrays.copyOf(values, values.length));
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"delegate.anyOf(*values)");
        return clientDslProperty;
    }

    @NotNull
    public final Request get$spring_cloud_contract_spec_kotlin() {
        Url it;
        boolean bl;
        boolean bl2;
        Url url;
        Request request = new Request();
        Url url2 = this.method;
        if (url2 != null) {
            url = url2;
            bl2 = false;
            bl = false;
            it = url;
            boolean bl3 = false;
            request.setMethod(this.getMethod());
        }
        url2 = this.url;
        if (url2 != null) {
            url = url2;
            bl2 = false;
            bl = false;
            it = url;
            boolean bl4 = false;
            request.setUrl(this.getUrl());
        }
        url2 = this.urlPath;
        if (url2 != null) {
            url = url2;
            bl2 = false;
            bl = false;
            it = url;
            boolean bl5 = false;
            request.setUrlPath(this.getUrlPath());
        }
        url2 = this.headers;
        if (url2 != null) {
            url = url2;
            bl2 = false;
            bl = false;
            it = url;
            boolean bl6 = false;
            request.setHeaders(this.getHeaders());
        }
        url2 = this.cookies;
        if (url2 != null) {
            url = url2;
            bl2 = false;
            bl = false;
            it = url;
            boolean bl7 = false;
            request.setCookies(this.getCookies());
        }
        url2 = this.body;
        if (url2 != null) {
            url = url2;
            bl2 = false;
            bl = false;
            it = url;
            boolean bl8 = false;
            request.setBody(this.getBody());
        }
        url2 = this.multipart;
        if (url2 != null) {
            url = url2;
            bl2 = false;
            bl = false;
            it = url;
            boolean bl9 = false;
            request.setMultipart(this.getMultipart());
        }
        url2 = this.bodyMatchers;
        if (url2 != null) {
            url = url2;
            bl2 = false;
            bl = false;
            it = url;
            boolean bl10 = false;
            request.setBodyMatchers(this.getBodyMatchers());
        }
        return request;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/springframework/cloud/contract/spec/internal/RequestDsl$RequestHeadersDsl;", "Lorg/springframework/cloud/contract/spec/internal/HeadersDsl;", "()V", "common", "Lorg/springframework/cloud/contract/spec/internal/Common;", "matching", "", "value", "spring-cloud-contract-spec-kotlin"})
    private static final class RequestHeadersDsl
    extends HeadersDsl {
        @NotNull
        private final Common common = new Common();

        @Override
        @Nullable
        public Object matching(@Nullable Object value) {
            Object object = value;
            if (object != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                Object object3 = value;
                return object3 instanceof String ? this.common.value(this.c(this.regex(Intrinsics.stringPlus((String)RegexpUtils.escapeSpecialRegexWithSingleEscape((String)((String)value)), (Object)".*"))), this.p(value)) : value;
            }
            return null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/springframework/cloud/contract/spec/internal/RequestDsl$RequestCookiesDsl;", "Lorg/springframework/cloud/contract/spec/internal/CookiesDsl;", "()V", "common", "Lorg/springframework/cloud/contract/spec/internal/Common;", "matching", "", "value", "spring-cloud-contract-spec-kotlin"})
    private static final class RequestCookiesDsl
    extends CookiesDsl {
        @NotNull
        private final Common common = new Common();

        @Override
        @Nullable
        public Object matching(@Nullable Object value) {
            Object object = value;
            if (object != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                Object object3 = value;
                return object3 instanceof String ? this.common.value(this.c(this.regex(Intrinsics.stringPlus((String)RegexpUtils.escapeSpecialRegexWithSingleEscape((String)((String)value)), (Object)".*"))), this.p(value)) : value;
            }
            return null;
        }
    }
}

