/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.contract.spec.ContractDslExtensionsKt;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.Common;
import org.springframework.cloud.contract.spec.internal.CommonDsl;
import org.springframework.cloud.contract.spec.internal.ContractDslMarker;
import org.springframework.cloud.contract.spec.internal.Cookies;
import org.springframework.cloud.contract.spec.internal.CookiesDsl;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.FromRequestDsl;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.HeadersDsl;
import org.springframework.cloud.contract.spec.internal.NotToEscapePattern;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.internal.Response;
import org.springframework.cloud.contract.spec.internal.ResponseBodyMatchers;
import org.springframework.cloud.contract.spec.internal.ResponseBodyMatchersDsl;
import org.springframework.cloud.contract.spec.internal.ServerDslProperty;
import org.springframework.cloud.contract.spec.util.RegexpUtils;

@ContractDslMarker
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\bw\n\u0002\u0018\u0002\n\u0002\b*\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0004\u00ed\u0001\u00ee\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u00ce\u0001\u001a\n ~*\u0004\u0018\u00010}0}2\u001a\u0010\u00cf\u0001\u001a\u000e\u0012\t\b\u0001\u0012\u0005\u0018\u00010\u00d1\u00010\u00d0\u0001\"\u0005\u0018\u00010\u00d1\u0001\u00a2\u0006\u0003\u0010\u00d2\u0001J\u0011\u0010\u00ad\u0001\u001a\u00030\u00ae\u00012\u0007\u0010\u00ad\u0001\u001a\u00020\u0005J@\u0010\u00ad\u0001\u001a\u00030\u00ae\u000120\u0010\u00ad\u0001\u001a\u0019\u0012\u0014\b\u0001\u0012\u0010\u0012\u0005\u0012\u00030\u00d1\u0001\u0012\u0004\u0012\u00020\u00050\u00d3\u00010\u00d0\u0001\"\u0010\u0012\u0005\u0012\u00030\u00d1\u0001\u0012\u0004\u0012\u00020\u00050\u00d3\u0001\u00a2\u0006\u0003\u0010\u00d4\u0001J\u001f\u0010\u00ad\u0001\u001a\u00030\u00ae\u00012\u0015\u0010\u00ad\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u00d1\u0001\u0012\u0004\u0012\u00020\u00050\u00d3\u0001J\u0018\u0010\u00ad\u0001\u001a\u00030\u00ae\u00012\u000e\u0010\u00ad\u0001\u001a\t\u0012\u0004\u0012\u00020\u00050\u00d5\u0001J\u001f\u0010\u00ad\u0001\u001a\u00030\u00ae\u00012\u0015\u0010\u00ad\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u00d1\u0001\u0012\u0004\u0012\u00020\u00050\u00d6\u0001J&\u0010\u00b3\u0001\u001a\u00030\u00d7\u00012\u001c\u0010\u00d8\u0001\u001a\u0017\u0012\u0005\u0012\u00030\u00da\u0001\u0012\u0005\u0012\u00030\u00d7\u00010\u00d9\u0001\u00a2\u0006\u0003\b\u00db\u0001J\u0017\u0010\u00dc\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u00dc\u0001\u001a\u00030\u00dd\u0001J&\u0010\u00b9\u0001\u001a\u00030\u00d7\u00012\u001c\u0010\u00b9\u0001\u001a\u0017\u0012\u0005\u0012\u00030\u00de\u0001\u0012\u0005\u0012\u00030\u00d7\u00010\u00d9\u0001\u00a2\u0006\u0003\b\u00db\u0001J\u0017\u0010\u00df\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u00bf\u0001\u001a\u00030\u00dd\u0001J\u0017\u0010\u00df\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u00bf\u0001\u001a\u00030\u00e0\u0001J\b\u0010\u00e1\u0001\u001a\u00030\u00e2\u0001J\u0010\u0010\u00e3\u0001\u001a\u00030\u00c4\u0001H\u0000\u00a2\u0006\u0003\b\u00e4\u0001J&\u0010\u00c5\u0001\u001a\u00030\u00d7\u00012\u001c\u0010\u00c5\u0001\u001a\u0017\u0012\u0005\u0012\u00030\u00e5\u0001\u0012\u0005\u0012\u00030\u00d7\u00010\u00d9\u0001\u00a2\u0006\u0003\b\u00db\u0001J1\u0010\u00e6\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\b\u0010\u00e7\u0001\u001a\u00030\u00e8\u0001J2\u0010\u00e6\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\t\u0010\u00e7\u0001\u001a\u0004\u0018\u00010\u0005J1\u0010\u00e6\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\b\u0010\u00e7\u0001\u001a\u00030\u00e9\u0001J:\u0010\u00e6\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\b\u0010\u00ea\u0001\u001a\u00030\u00e9\u00012\u0007\u0010\u00eb\u0001\u001a\u00020}J6\u0010\u00e6\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\r\u0010\u00e7\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J1\u0010\u00e6\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\b\u0010\u00e7\u0001\u001a\u00030\u00ec\u0001J:\u0010\u00e6\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\u0007\u0010\u00eb\u0001\u001a\u00020}2\b\u0010\u00ea\u0001\u001a\u00030\u00e9\u0001J1\u0010\u00e7\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\b\u0010\u00e7\u0001\u001a\u00030\u00e8\u0001J2\u0010\u00e7\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\t\u0010\u00e7\u0001\u001a\u0004\u0018\u00010\u0005J1\u0010\u00e7\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\b\u0010\u00e7\u0001\u001a\u00030\u00e9\u0001J:\u0010\u00e7\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\b\u0010\u00ea\u0001\u001a\u00030\u00e9\u00012\u0007\u0010\u00eb\u0001\u001a\u00020}J6\u0010\u00e7\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\r\u0010\u00e7\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J1\u0010\u00e7\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\b\u0010\u00e7\u0001\u001a\u00030\u00ec\u0001J:\u0010\u00e7\u0001\u001a\"\u0012\f\u0012\n ~*\u0004\u0018\u00010\u00050\u0005 ~*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a8\u0006\u00010\u0004\u00a8\u0006\u00012\u0007\u0010\u00eb\u0001\u001a\u00020}2\b\u0010\u00ea\u0001\u001a\u00030\u00e9\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0007R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0007R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0007R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0007R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0007R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0007R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0007R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0007R\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0007R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0007R\u0017\u00104\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0007R\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0007R\u0017\u00108\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0007R\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0007R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0007R\u0017\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0007R\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0007R\u0017\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0007R\u0017\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u0007R\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u0007R\u0017\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bI\u0010\u0007R\u0017\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bK\u0010\u0007R\u0017\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bM\u0010\u0007R\u0017\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u0007R\u0017\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010\u0007R\u0017\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bS\u0010\u0007R\u0017\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bU\u0010\u0007R\u0017\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bW\u0010\u0007R\u0017\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bY\u0010\u0007R\u0017\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\u0007R\u0017\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b]\u0010\u0007R\u0017\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b_\u0010\u0007R\u0017\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\ba\u0010\u0007R\u0017\u0010b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bc\u0010\u0007R\u0017\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\be\u0010\u0007R\u0017\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bg\u0010\u0007R\u0017\u0010h\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bi\u0010\u0007R\u0017\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bk\u0010\u0007R\u0017\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bm\u0010\u0007R\u0017\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bo\u0010\u0007R\u0017\u0010p\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bq\u0010\u0007R\u0017\u0010r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bs\u0010\u0007R\u0017\u0010t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bu\u0010\u0007R\u0017\u0010v\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\bw\u0010\u0007R\u0017\u0010x\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\by\u0010\u0007R\u0017\u0010z\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b{\u0010\u0007R\u001a\u0010|\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\u0007\u001a\u0005\b\u007f\u0010\u0080\u0001R\u001c\u0010\u0081\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u0082\u0001\u0010\u0080\u0001R\u001c\u0010\u0083\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u0084\u0001\u0010\u0080\u0001R\u001c\u0010\u0085\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u0086\u0001\u0010\u0080\u0001R\u001c\u0010\u0087\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u0088\u0001\u0010\u0080\u0001R\u001c\u0010\u0089\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u008a\u0001\u0010\u0080\u0001R\u001c\u0010\u008b\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u008c\u0001\u0010\u0080\u0001R\u001c\u0010\u008d\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u008e\u0001\u0010\u0080\u0001R\u001c\u0010\u008f\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u0090\u0001\u0010\u0080\u0001R\u001c\u0010\u0091\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u0092\u0001\u0010\u0080\u0001R\u001c\u0010\u0093\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u0094\u0001\u0010\u0080\u0001R\u001c\u0010\u0095\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u0096\u0001\u0010\u0080\u0001R\u001c\u0010\u0097\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u0098\u0001\u0010\u0080\u0001R\u001c\u0010\u0099\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u009a\u0001\u0010\u0080\u0001R\u001c\u0010\u009b\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u009c\u0001\u0010\u0080\u0001R\u001c\u0010\u009d\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u009e\u0001\u0010\u0080\u0001R\u001c\u0010\u009f\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u00a0\u0001\u0010\u0080\u0001R\u001c\u0010\u00a1\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u00a2\u0001\u0010\u0080\u0001R\u001c\u0010\u00a3\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u00a4\u0001\u0010\u0080\u0001R\u001c\u0010\u00a5\u0001\u001a\n ~*\u0004\u0018\u00010}0}8F\u00a2\u0006\b\u001a\u0006\b\u00a6\u0001\u0010\u0080\u0001R \u0010\u00a7\u0001\u001a\u00030\u00a8\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00a9\u0001\u0010\u00aa\u0001\"\u0006\b\u00ab\u0001\u0010\u00ac\u0001R\"\u0010\u00ad\u0001\u001a\u0005\u0018\u00010\u00ae\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00af\u0001\u0010\u00b0\u0001\"\u0006\b\u00b1\u0001\u0010\u00b2\u0001R\"\u0010\u00b3\u0001\u001a\u0005\u0018\u00010\u00b4\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00b5\u0001\u0010\u00b6\u0001\"\u0006\b\u00b7\u0001\u0010\u00b8\u0001R\"\u0010\u00b9\u0001\u001a\u0005\u0018\u00010\u00ba\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00bb\u0001\u0010\u00bc\u0001\"\u0006\b\u00bd\u0001\u0010\u00be\u0001R&\u0010\u00bf\u0001\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0011\n\u0000\u001a\u0005\b\u00c0\u0001\u0010\u0007\"\u0006\b\u00c1\u0001\u0010\u00c2\u0001R\u0010\u0010\u00c3\u0001\u001a\u00030\u00c4\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u00c5\u0001\u001a\u0005\u0018\u00010\u00c6\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00c7\u0001\u0010\u00c8\u0001\"\u0006\b\u00c9\u0001\u0010\u00ca\u0001R&\u0010\u00cb\u0001\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0011\n\u0000\u001a\u0005\b\u00cc\u0001\u0010\u0007\"\u0006\b\u00cd\u0001\u0010\u00c2\u0001\u00a8\u0006\u00ef\u0001"}, d2={"Lorg/springframework/cloud/contract/spec/internal/ResponseDsl;", "Lorg/springframework/cloud/contract/spec/internal/CommonDsl;", "()V", "ACCEPTED", "Lorg/springframework/cloud/contract/spec/internal/DslProperty;", "", "getACCEPTED", "()Lorg/springframework/cloud/contract/spec/internal/DslProperty;", "ALREADY_REPORTED", "getALREADY_REPORTED", "BAD_GATEWAY", "getBAD_GATEWAY", "BAD_REQUEST", "getBAD_REQUEST", "BANDWIDTH_LIMIT_EXCEEDED", "getBANDWIDTH_LIMIT_EXCEEDED", "CHECKPOINT", "getCHECKPOINT", "CONFLICT", "getCONFLICT", "CONTINUE", "getCONTINUE", "CREATED", "getCREATED", "EXPECTATION_FAILED", "getEXPECTATION_FAILED", "FAILED_DEPENDENCY", "getFAILED_DEPENDENCY", "FORBIDDEN", "getFORBIDDEN", "FOUND", "getFOUND", "GATEWAY_TIMEOUT", "getGATEWAY_TIMEOUT", "GONE", "getGONE", "HTTP_VERSION_NOT_SUPPORTED", "getHTTP_VERSION_NOT_SUPPORTED", "IM_USED", "getIM_USED", "INSUFFICIENT_STORAGE", "getINSUFFICIENT_STORAGE", "INTERNAL_SERVER_ERROR", "getINTERNAL_SERVER_ERROR", "I_AM_A_TEAPOT", "getI_AM_A_TEAPOT", "LENGTH_REQUIRED", "getLENGTH_REQUIRED", "LOCKED", "getLOCKED", "LOOP_DETECTED", "getLOOP_DETECTED", "METHOD_NOT_ALLOWED", "getMETHOD_NOT_ALLOWED", "MOVED_PERMANENTLY", "getMOVED_PERMANENTLY", "MULTIPLE_CHOICES", "getMULTIPLE_CHOICES", "MULTI_STATUS", "getMULTI_STATUS", "NETWORK_AUTHENTICATION_REQUIRED", "getNETWORK_AUTHENTICATION_REQUIRED", "NON_AUTHORITATIVE_INFORMATION", "getNON_AUTHORITATIVE_INFORMATION", "NOT_ACCEPTABLE", "getNOT_ACCEPTABLE", "NOT_EXTENDED", "getNOT_EXTENDED", "NOT_FOUND", "getNOT_FOUND", "NOT_IMPLEMENTED", "getNOT_IMPLEMENTED", "NOT_MODIFIED", "getNOT_MODIFIED", "NO_CONTENT", "getNO_CONTENT", "OK", "getOK", "PARTIAL_CONTENT", "getPARTIAL_CONTENT", "PAYLOAD_TOO_LARGE", "getPAYLOAD_TOO_LARGE", "PAYMENT_REQUIRED", "getPAYMENT_REQUIRED", "PERMANENT_REDIRECT", "getPERMANENT_REDIRECT", "PRECONDITION_FAILED", "getPRECONDITION_FAILED", "PRECONDITION_REQUIRED", "getPRECONDITION_REQUIRED", "PROCESSING", "getPROCESSING", "PROXY_AUTHENTICATION_REQUIRED", "getPROXY_AUTHENTICATION_REQUIRED", "REQUESTED_RANGE_NOT_SATISFIABLE", "getREQUESTED_RANGE_NOT_SATISFIABLE", "REQUEST_HEADER_FIELDS_TOO_LARGE", "getREQUEST_HEADER_FIELDS_TOO_LARGE", "REQUEST_TIMEOUT", "getREQUEST_TIMEOUT", "RESET_CONTENT", "getRESET_CONTENT", "SEE_OTHER", "getSEE_OTHER", "SERVICE_UNAVAILABLE", "getSERVICE_UNAVAILABLE", "SWITCHING_PROTOCOLS", "getSWITCHING_PROTOCOLS", "TEMPORARY_REDIRECT", "getTEMPORARY_REDIRECT", "TOO_MANY_REQUESTS", "getTOO_MANY_REQUESTS", "UNAUTHORIZED", "getUNAUTHORIZED", "UNAVAILABLE_FOR_LEGAL_REASONS", "getUNAVAILABLE_FOR_LEGAL_REASONS", "UNPROCESSABLE_ENTITY", "getUNPROCESSABLE_ENTITY", "UNSUPPORTED_MEDIA_TYPE", "getUNSUPPORTED_MEDIA_TYPE", "UPGRADE_REQUIRED", "getUPGRADE_REQUIRED", "VARIANT_ALSO_NEGOTIATES", "getVARIANT_ALSO_NEGOTIATES", "aBoolean", "Lorg/springframework/cloud/contract/spec/internal/ServerDslProperty;", "kotlin.jvm.PlatformType", "getABoolean", "()Lorg/springframework/cloud/contract/spec/internal/ServerDslProperty;", "anyAlphaNumeric", "getAnyAlphaNumeric", "anyAlphaUnicode", "getAnyAlphaUnicode", "anyDate", "getAnyDate", "anyDateTime", "getAnyDateTime", "anyDouble", "getAnyDouble", "anyEmail", "getAnyEmail", "anyHex", "getAnyHex", "anyHostname", "getAnyHostname", "anyHttpsUrl", "getAnyHttpsUrl", "anyInteger", "getAnyInteger", "anyIpAddress", "getAnyIpAddress", "anyIso8601WithOffset", "getAnyIso8601WithOffset", "anyNonBlankString", "getAnyNonBlankString", "anyNonEmptyString", "getAnyNonEmptyString", "anyNumber", "getAnyNumber", "anyPositiveInt", "getAnyPositiveInt", "anyTime", "getAnyTime", "anyUrl", "getAnyUrl", "anyUuid", "getAnyUuid", "async", "", "getAsync", "()Z", "setAsync", "(Z)V", "body", "Lorg/springframework/cloud/contract/spec/internal/Body;", "getBody", "()Lorg/springframework/cloud/contract/spec/internal/Body;", "setBody", "(Lorg/springframework/cloud/contract/spec/internal/Body;)V", "bodyMatchers", "Lorg/springframework/cloud/contract/spec/internal/ResponseBodyMatchers;", "getBodyMatchers", "()Lorg/springframework/cloud/contract/spec/internal/ResponseBodyMatchers;", "setBodyMatchers", "(Lorg/springframework/cloud/contract/spec/internal/ResponseBodyMatchers;)V", "cookies", "Lorg/springframework/cloud/contract/spec/internal/Cookies;", "getCookies", "()Lorg/springframework/cloud/contract/spec/internal/Cookies;", "setCookies", "(Lorg/springframework/cloud/contract/spec/internal/Cookies;)V", "delay", "getDelay", "setDelay", "(Lorg/springframework/cloud/contract/spec/internal/DslProperty;)V", "delegate", "Lorg/springframework/cloud/contract/spec/internal/Response;", "headers", "Lorg/springframework/cloud/contract/spec/internal/Headers;", "getHeaders", "()Lorg/springframework/cloud/contract/spec/internal/Headers;", "setHeaders", "(Lorg/springframework/cloud/contract/spec/internal/Headers;)V", "status", "getStatus", "setStatus", "anyOf", "values", "", "", "([Ljava/lang/String;)Lorg/springframework/cloud/contract/spec/internal/ServerDslProperty;", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lorg/springframework/cloud/contract/spec/internal/Body;", "", "", "", "configurer", "Lkotlin/Function1;", "Lorg/springframework/cloud/contract/spec/internal/ResponseBodyMatchersDsl;", "Lkotlin/ExtensionFunctionType;", "code", "", "Lorg/springframework/cloud/contract/spec/internal/CookiesDsl;", "fixedMilliseconds", "", "fromRequest", "Lorg/springframework/cloud/contract/spec/internal/FromRequestDsl;", "get", "get$spring_cloud_contract_spec_kotlin", "Lorg/springframework/cloud/contract/spec/internal/HeadersDsl;", "v", "value", "Ljava/util/regex/Pattern;", "Lorg/springframework/cloud/contract/spec/internal/ClientDslProperty;", "client", "server", "Lorg/springframework/cloud/contract/spec/internal/RegexProperty;", "ResponseCookiesDsl", "ResponseHeadersDsl", "spring-cloud-contract-spec-kotlin"})
public final class ResponseDsl
extends CommonDsl {
    private final Response delegate = new Response();
    @Nullable
    private DslProperty<Object> status;
    @Nullable
    private DslProperty<Object> delay;
    @Nullable
    private Headers headers;
    @Nullable
    private Cookies cookies;
    @Nullable
    private Body body;
    private boolean async;
    @Nullable
    private ResponseBodyMatchers bodyMatchers;

    @Nullable
    public final DslProperty<Object> getStatus() {
        return this.status;
    }

    public final void setStatus(@Nullable DslProperty<Object> dslProperty) {
        this.status = dslProperty;
    }

    @Nullable
    public final DslProperty<Object> getDelay() {
        return this.delay;
    }

    public final void setDelay(@Nullable DslProperty<Object> dslProperty) {
        this.delay = dslProperty;
    }

    @Nullable
    public final Headers getHeaders() {
        return this.headers;
    }

    public final void setHeaders(@Nullable Headers headers) {
        this.headers = headers;
    }

    @Nullable
    public final Cookies getCookies() {
        return this.cookies;
    }

    public final void setCookies(@Nullable Cookies cookies) {
        this.cookies = cookies;
    }

    @Nullable
    public final Body getBody() {
        return this.body;
    }

    public final void setBody(@Nullable Body body) {
        this.body = body;
    }

    public final boolean getAsync() {
        return this.async;
    }

    public final void setAsync(boolean bl) {
        this.async = bl;
    }

    @Nullable
    public final ResponseBodyMatchers getBodyMatchers() {
        return this.bodyMatchers;
    }

    public final void setBodyMatchers(@Nullable ResponseBodyMatchers responseBodyMatchers) {
        this.bodyMatchers = responseBodyMatchers;
    }

    @NotNull
    public final DslProperty<Object> code(int code) {
        return ContractDslExtensionsKt.toDslProperty(code);
    }

    @NotNull
    public final DslProperty<Object> fixedMilliseconds(int delay) {
        return ContractDslExtensionsKt.toDslProperty(delay);
    }

    @NotNull
    public final DslProperty<Object> fixedMilliseconds(long delay) {
        return this.fixedMilliseconds((int)delay);
    }

    public final void headers(@NotNull Function1<? super HeadersDsl, Unit> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        ResponseHeadersDsl responseHeadersDsl = new ResponseHeadersDsl();
        boolean bl = false;
        boolean bl2 = false;
        headers.invoke((Object)responseHeadersDsl);
        this.headers = responseHeadersDsl.get$spring_cloud_contract_spec_kotlin();
    }

    public final void cookies(@NotNull Function1<? super CookiesDsl, Unit> cookies) {
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        ResponseCookiesDsl responseCookiesDsl = new ResponseCookiesDsl();
        boolean bl = false;
        boolean bl2 = false;
        cookies.invoke((Object)responseCookiesDsl);
        this.cookies = responseCookiesDsl.get$spring_cloud_contract_spec_kotlin();
    }

    @NotNull
    public final Body body(@NotNull Map<String, ? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(body));
    }

    @NotNull
    public final Body body(Pair<String, ? extends Object> ... body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(MapsKt.toMap(body)));
    }

    @NotNull
    public final Body body(@NotNull Pair<String, ? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(MapsKt.mapOf(body)));
    }

    @NotNull
    public final Body body(@NotNull List<? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(body));
    }

    @NotNull
    public final Body body(@NotNull Object body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return new Body(body);
    }

    public final void bodyMatchers(@NotNull Function1<? super ResponseBodyMatchersDsl, Unit> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        ResponseBodyMatchersDsl responseBodyMatchersDsl = new ResponseBodyMatchersDsl();
        boolean bl = false;
        boolean bl2 = false;
        configurer.invoke((Object)responseBodyMatchersDsl);
        this.bodyMatchers = responseBodyMatchersDsl.get$spring_cloud_contract_spec_kotlin();
    }

    @NotNull
    public final DslProperty<Object> getCONTINUE() {
        return this.code(100);
    }

    @NotNull
    public final DslProperty<Object> getSWITCHING_PROTOCOLS() {
        return this.code(101);
    }

    @NotNull
    public final DslProperty<Object> getPROCESSING() {
        return this.code(102);
    }

    @NotNull
    public final DslProperty<Object> getCHECKPOINT() {
        return this.code(103);
    }

    @NotNull
    public final DslProperty<Object> getOK() {
        return this.code(200);
    }

    @NotNull
    public final DslProperty<Object> getCREATED() {
        return this.code(201);
    }

    @NotNull
    public final DslProperty<Object> getACCEPTED() {
        return this.code(202);
    }

    @NotNull
    public final DslProperty<Object> getNON_AUTHORITATIVE_INFORMATION() {
        return this.code(203);
    }

    @NotNull
    public final DslProperty<Object> getNO_CONTENT() {
        return this.code(204);
    }

    @NotNull
    public final DslProperty<Object> getRESET_CONTENT() {
        return this.code(205);
    }

    @NotNull
    public final DslProperty<Object> getPARTIAL_CONTENT() {
        return this.code(206);
    }

    @NotNull
    public final DslProperty<Object> getMULTI_STATUS() {
        return this.code(207);
    }

    @NotNull
    public final DslProperty<Object> getALREADY_REPORTED() {
        return this.code(208);
    }

    @NotNull
    public final DslProperty<Object> getIM_USED() {
        return this.code(226);
    }

    @NotNull
    public final DslProperty<Object> getMULTIPLE_CHOICES() {
        return this.code(300);
    }

    @NotNull
    public final DslProperty<Object> getMOVED_PERMANENTLY() {
        return this.code(301);
    }

    @NotNull
    public final DslProperty<Object> getFOUND() {
        return this.code(302);
    }

    @NotNull
    public final DslProperty<Object> getSEE_OTHER() {
        return this.code(303);
    }

    @NotNull
    public final DslProperty<Object> getNOT_MODIFIED() {
        return this.code(304);
    }

    @NotNull
    public final DslProperty<Object> getTEMPORARY_REDIRECT() {
        return this.code(307);
    }

    @NotNull
    public final DslProperty<Object> getPERMANENT_REDIRECT() {
        return this.code(308);
    }

    @NotNull
    public final DslProperty<Object> getBAD_REQUEST() {
        return this.code(400);
    }

    @NotNull
    public final DslProperty<Object> getUNAUTHORIZED() {
        return this.code(401);
    }

    @NotNull
    public final DslProperty<Object> getPAYMENT_REQUIRED() {
        return this.code(402);
    }

    @NotNull
    public final DslProperty<Object> getFORBIDDEN() {
        return this.code(403);
    }

    @NotNull
    public final DslProperty<Object> getNOT_FOUND() {
        return this.code(404);
    }

    @NotNull
    public final DslProperty<Object> getMETHOD_NOT_ALLOWED() {
        return this.code(405);
    }

    @NotNull
    public final DslProperty<Object> getNOT_ACCEPTABLE() {
        return this.code(406);
    }

    @NotNull
    public final DslProperty<Object> getPROXY_AUTHENTICATION_REQUIRED() {
        return this.code(407);
    }

    @NotNull
    public final DslProperty<Object> getREQUEST_TIMEOUT() {
        return this.code(408);
    }

    @NotNull
    public final DslProperty<Object> getCONFLICT() {
        return this.code(409);
    }

    @NotNull
    public final DslProperty<Object> getGONE() {
        return this.code(410);
    }

    @NotNull
    public final DslProperty<Object> getLENGTH_REQUIRED() {
        return this.code(411);
    }

    @NotNull
    public final DslProperty<Object> getPRECONDITION_FAILED() {
        return this.code(412);
    }

    @NotNull
    public final DslProperty<Object> getPAYLOAD_TOO_LARGE() {
        return this.code(413);
    }

    @NotNull
    public final DslProperty<Object> getUNSUPPORTED_MEDIA_TYPE() {
        return this.code(415);
    }

    @NotNull
    public final DslProperty<Object> getREQUESTED_RANGE_NOT_SATISFIABLE() {
        return this.code(416);
    }

    @NotNull
    public final DslProperty<Object> getEXPECTATION_FAILED() {
        return this.code(417);
    }

    @NotNull
    public final DslProperty<Object> getI_AM_A_TEAPOT() {
        return this.code(418);
    }

    @NotNull
    public final DslProperty<Object> getUNPROCESSABLE_ENTITY() {
        return this.code(422);
    }

    @NotNull
    public final DslProperty<Object> getLOCKED() {
        return this.code(423);
    }

    @NotNull
    public final DslProperty<Object> getFAILED_DEPENDENCY() {
        return this.code(424);
    }

    @NotNull
    public final DslProperty<Object> getUPGRADE_REQUIRED() {
        return this.code(426);
    }

    @NotNull
    public final DslProperty<Object> getPRECONDITION_REQUIRED() {
        return this.code(428);
    }

    @NotNull
    public final DslProperty<Object> getTOO_MANY_REQUESTS() {
        return this.code(429);
    }

    @NotNull
    public final DslProperty<Object> getREQUEST_HEADER_FIELDS_TOO_LARGE() {
        return this.code(431);
    }

    @NotNull
    public final DslProperty<Object> getUNAVAILABLE_FOR_LEGAL_REASONS() {
        return this.code(451);
    }

    @NotNull
    public final DslProperty<Object> getINTERNAL_SERVER_ERROR() {
        return this.code(500);
    }

    @NotNull
    public final DslProperty<Object> getNOT_IMPLEMENTED() {
        return this.code(501);
    }

    @NotNull
    public final DslProperty<Object> getBAD_GATEWAY() {
        return this.code(502);
    }

    @NotNull
    public final DslProperty<Object> getSERVICE_UNAVAILABLE() {
        return this.code(503);
    }

    @NotNull
    public final DslProperty<Object> getGATEWAY_TIMEOUT() {
        return this.code(504);
    }

    @NotNull
    public final DslProperty<Object> getHTTP_VERSION_NOT_SUPPORTED() {
        return this.code(505);
    }

    @NotNull
    public final DslProperty<Object> getVARIANT_ALSO_NEGOTIATES() {
        return this.code(506);
    }

    @NotNull
    public final DslProperty<Object> getINSUFFICIENT_STORAGE() {
        return this.code(507);
    }

    @NotNull
    public final DslProperty<Object> getLOOP_DETECTED() {
        return this.code(508);
    }

    @NotNull
    public final DslProperty<Object> getBANDWIDTH_LIMIT_EXCEEDED() {
        return this.code(509);
    }

    @NotNull
    public final DslProperty<Object> getNOT_EXTENDED() {
        return this.code(510);
    }

    @NotNull
    public final DslProperty<Object> getNETWORK_AUTHENTICATION_REQUIRED() {
        return this.code(511);
    }

    public final ServerDslProperty getAnyAlphaUnicode() {
        return this.delegate.anyAlphaUnicode();
    }

    public final ServerDslProperty getAnyAlphaNumeric() {
        return this.delegate.anyAlphaNumeric();
    }

    public final ServerDslProperty getAnyNumber() {
        return this.delegate.anyNumber();
    }

    public final ServerDslProperty getAnyInteger() {
        return this.delegate.anyInteger();
    }

    public final ServerDslProperty getAnyPositiveInt() {
        return this.delegate.anyPositiveInt();
    }

    public final ServerDslProperty getAnyDouble() {
        return this.delegate.anyDouble();
    }

    public final ServerDslProperty getAnyHex() {
        return this.delegate.anyHex();
    }

    public final ServerDslProperty getABoolean() {
        return this.delegate.aBoolean();
    }

    public final ServerDslProperty getAnyIpAddress() {
        return this.delegate.anyIpAddress();
    }

    public final ServerDslProperty getAnyHostname() {
        return this.delegate.anyHostname();
    }

    public final ServerDslProperty getAnyEmail() {
        return this.delegate.anyEmail();
    }

    public final ServerDslProperty getAnyUrl() {
        return this.delegate.anyUrl();
    }

    public final ServerDslProperty getAnyHttpsUrl() {
        return this.delegate.anyHttpsUrl();
    }

    public final ServerDslProperty getAnyUuid() {
        return this.delegate.anyUuid();
    }

    public final ServerDslProperty getAnyDate() {
        return this.delegate.anyDate();
    }

    public final ServerDslProperty getAnyDateTime() {
        return this.delegate.anyDateTime();
    }

    public final ServerDslProperty getAnyTime() {
        return this.delegate.anyTime();
    }

    public final ServerDslProperty getAnyIso8601WithOffset() {
        return this.delegate.anyIso8601WithOffset();
    }

    public final ServerDslProperty getAnyNonBlankString() {
        return this.delegate.anyNonBlankString();
    }

    public final ServerDslProperty getAnyNonEmptyString() {
        return this.delegate.anyNonEmptyString();
    }

    public final DslProperty<Object> value(@NotNull ClientDslProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.delegate.value((DslProperty)value);
    }

    public final DslProperty<Object> v(@NotNull ClientDslProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.delegate.value((DslProperty)value);
    }

    public final DslProperty<Object> value(@NotNull DslProperty<Object> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.delegate.value(value);
    }

    public final DslProperty<Object> v(@NotNull DslProperty<Object> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.delegate.value(value);
    }

    public final DslProperty<Object> value(@NotNull Pattern value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.delegate.value(value);
    }

    public final DslProperty<Object> v(@NotNull Pattern value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.delegate.value(value);
    }

    public final DslProperty<Object> value(@NotNull RegexProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.delegate.value(value);
    }

    public final DslProperty<Object> v(@NotNull RegexProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.delegate.value(value);
    }

    public final DslProperty<Object> value(@Nullable Object value) {
        return this.delegate.value(value);
    }

    public final DslProperty<Object> v(@Nullable Object value) {
        return this.delegate.value(value);
    }

    public final DslProperty<Object> value(@NotNull ClientDslProperty client, @NotNull ServerDslProperty server) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return this.delegate.value(client, server);
    }

    public final DslProperty<Object> v(@NotNull ClientDslProperty client, @NotNull ServerDslProperty server) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return this.delegate.value(client, server);
    }

    public final DslProperty<Object> value(@NotNull ServerDslProperty server, @NotNull ClientDslProperty client) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return this.delegate.value(client, server);
    }

    public final DslProperty<Object> v(@NotNull ServerDslProperty server, @NotNull ClientDslProperty client) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return this.delegate.value(client, server);
    }

    @NotNull
    public final FromRequestDsl fromRequest() {
        return new FromRequestDsl();
    }

    public final ServerDslProperty anyOf(String ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return this.delegate.anyOf(Arrays.copyOf(values, values.length));
    }

    @NotNull
    public final Response get$spring_cloud_contract_spec_kotlin() {
        Response response;
        block5: {
            Headers it;
            boolean bl;
            boolean bl2;
            Headers headers;
            response = new Response();
            Headers headers2 = this.status;
            if (headers2 != null) {
                headers = headers2;
                bl2 = false;
                bl = false;
                it = headers;
                boolean bl3 = false;
                response.setStatus(this.status);
            }
            DslProperty<Object> dslProperty = this.delay;
            if (dslProperty != null) {
                headers = dslProperty;
                bl2 = false;
                bl = false;
                it = headers;
                boolean bl4 = false;
                response.setDelay(this.delay);
            }
            Headers headers3 = this.headers;
            if (headers3 != null) {
                headers = headers3;
                bl2 = false;
                bl = false;
                it = headers;
                boolean bl5 = false;
                response.setHeaders(this.headers);
            }
            Cookies cookies = this.cookies;
            if (cookies != null) {
                headers = cookies;
                bl2 = false;
                bl = false;
                it = headers;
                boolean bl6 = false;
                response.setCookies(this.cookies);
            }
            Body body = this.body;
            if (body != null) {
                headers = body;
                bl2 = false;
                bl = false;
                it = headers;
                boolean bl7 = false;
                response.setBody(this.body);
            }
            response.setAsync(this.async);
            ResponseBodyMatchers responseBodyMatchers = this.bodyMatchers;
            if (responseBodyMatchers == null) break block5;
            headers = responseBodyMatchers;
            bl2 = false;
            bl = false;
            it = headers;
            boolean bl8 = false;
            response.setBodyMatchers(this.bodyMatchers);
        }
        return response;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/springframework/cloud/contract/spec/internal/ResponseDsl$ResponseHeadersDsl;", "Lorg/springframework/cloud/contract/spec/internal/HeadersDsl;", "()V", "common", "Lorg/springframework/cloud/contract/spec/internal/Common;", "matching", "", "value", "spring-cloud-contract-spec-kotlin"})
    private static final class ResponseHeadersDsl
    extends HeadersDsl {
        private final Common common = new Common();

        @Override
        @Nullable
        public Object matching(@Nullable Object value) {
            Object object = value;
            if (object != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                Object object3 = value;
                if (object3 instanceof String) {
                    return this.common.value(this.c(value), this.p(new NotToEscapePattern(Pattern.compile(RegexpUtils.escapeSpecialRegexWithSingleEscape((String)((String)value)) + ".*"))));
                }
                return value;
            }
            return null;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/springframework/cloud/contract/spec/internal/ResponseDsl$ResponseCookiesDsl;", "Lorg/springframework/cloud/contract/spec/internal/CookiesDsl;", "()V", "common", "Lorg/springframework/cloud/contract/spec/internal/Common;", "matching", "", "value", "spring-cloud-contract-spec-kotlin"})
    private static final class ResponseCookiesDsl
    extends CookiesDsl {
        private final Common common = new Common();

        @Override
        @Nullable
        public Object matching(@Nullable Object value) {
            Object object = value;
            if (object != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                Object object3 = value;
                if (object3 instanceof String) {
                    return this.common.value(this.c(value), this.p(this.regex(RegexpUtils.escapeSpecialRegexWithSingleEscape((String)((String)value)) + ".*")));
                }
                return value;
            }
            return null;
        }
    }
}

