/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.DslPropertyConverter;
import org.springframework.cloud.contract.spec.internal.QueryParameters;
import org.springframework.cloud.contract.spec.util.ValidateUtils;

public class Url
extends DslProperty {
    private QueryParameters queryParameters;

    public Url(DslProperty prop) {
        super(prop.getClientValue(), prop.getServerValue());
        ValidateUtils.validateServerValueIsAvailable(prop.getServerValue(), "Url");
    }

    public Url(Object url) {
        super(url, Url.testUrl(url));
        ValidateUtils.validateServerValueIsAvailable(url, "Url");
    }

    private static Object testUrl(Object url) {
        return DslPropertyConverter.INSTANCE.testSide(url);
    }

    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(QueryParameters queryParameters) {
        this.queryParameters = queryParameters;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Url url = (Url)o;
        return Objects.equals(this.queryParameters, url.queryParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.queryParameters);
    }

    @Override
    public String toString() {
        return "Url{\nqueryParameters=" + String.valueOf(this.queryParameters) + "} \n" + super.toString();
    }

    public void queryParameters(Consumer<QueryParameters> consumer) {
        this.queryParameters = new QueryParameters();
        consumer.accept(this.queryParameters);
    }

    public void queryParameters(@DelegatesTo(value=QueryParameters.class) Closure consumer) {
        this.queryParameters = new QueryParameters();
        consumer.setDelegate((Object)this.queryParameters);
        consumer.call();
    }
}

