/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Objects;
import org.springframework.cloud.contract.spec.internal.ContractUtils;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.util.ValidateUtils;

public class QueryParameter
extends DslProperty {
    private String name;

    public QueryParameter(String name, DslProperty dslProperty) {
        super(dslProperty.getClientValue(), dslProperty.getServerValue());
        ValidateUtils.validateServerValueIsAvailable(dslProperty.getServerValue(), "Query parameter '" + name + "'");
        this.name = name;
    }

    public QueryParameter(String name, MatchingStrategy matchingStrategy) {
        super(matchingStrategy);
        ValidateUtils.validateServerValueIsAvailable(matchingStrategy, "Query parameter '" + name + "'");
        this.name = name;
    }

    public QueryParameter(String name, Object value) {
        super(ContractUtils.CLIENT_VALUE.apply(value), ContractUtils.SERVER_VALUE.apply(value));
        ValidateUtils.validateServerValueIsAvailable(value, "Query parameter '" + name + "'");
        this.name = name;
    }

    public static QueryParameter build(String key, Object value) {
        if (value instanceof MatchingStrategy) {
            return new QueryParameter(key, (MatchingStrategy)value);
        }
        if (value instanceof RegexProperty) {
            return new QueryParameter(key, ((RegexProperty)value).dynamicClientEscapedConcreteProducer());
        }
        return new QueryParameter(key, value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QueryParameter that = (QueryParameter)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }

    @Override
    public String toString() {
        return "QueryParameter{name='" + this.name + "', value=" + super.toString() + "}";
    }
}

