/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.RandomStringGenerator;
import org.springframework.cloud.contract.spec.internal.RegexCreatingProperty;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;

abstract class PatternValueDslProperty<T extends DslProperty>
implements RegexCreatingProperty<T> {
    private final Random random = new Random();

    PatternValueDslProperty() {
    }

    protected T createAndValidateProperty(Pattern pattern, Object object) {
        if (object != null) {
            String generatedValue = object.toString();
            boolean matches = pattern.matcher(generatedValue).matches();
            if (!matches) {
                throw new IllegalStateException("The generated value [" + generatedValue + "] doesn't match the pattern [" + pattern.pattern() + "]");
            }
            return this.createProperty(pattern, object);
        }
        return this.createProperty(pattern, object);
    }

    protected T createAndValidateProperty(Pattern pattern) {
        return this.createAndValidateProperty(pattern, null);
    }

    protected abstract T createProperty(Pattern var1, Object var2);

    @Override
    public T anyAlphaUnicode() {
        return this.createAndValidateProperty(RegexPatterns.ONLY_ALPHA_UNICODE, RandomStringGenerator.randomString(20));
    }

    @Override
    public T anyAlphaNumeric() {
        return this.createAndValidateProperty(RegexPatterns.ALPHA_NUMERIC, RandomStringUtils.randomAlphanumeric((int)20));
    }

    @Override
    public T anyNumber() {
        return this.createAndValidateProperty(RegexPatterns.NUMBER, this.random.nextInt());
    }

    @Override
    public T anyInteger() {
        return this.createAndValidateProperty(RegexPatterns.INTEGER, this.random.nextInt());
    }

    @Override
    public T anyPositiveInt() {
        return this.createAndValidateProperty(RegexPatterns.POSITIVE_INT, Math.abs(this.random.nextInt() + 1));
    }

    @Override
    public T anyDouble() {
        return this.createAndValidateProperty(RegexPatterns.DOUBLE, (double)this.random.nextInt(100) + this.random.nextDouble());
    }

    @Override
    public T anyHex() {
        return this.createAndValidateProperty(RegexPatterns.HEX, RandomStringUtils.random((int)10, (String)"0123456789abcdef"));
    }

    @Override
    public T aBoolean() {
        return this.createAndValidateProperty(RegexPatterns.TRUE_OR_FALSE, this.random.nextBoolean());
    }

    @Override
    public T anyIpAddress() {
        return this.createAndValidateProperty(RegexPatterns.IP_ADDRESS, "192.168.0." + this.random.nextInt(10));
    }

    @Override
    public T anyHostname() {
        return this.createAndValidateProperty(RegexPatterns.HOSTNAME_PATTERN, "https://foo" + this.random.nextInt() + ".com");
    }

    @Override
    public T anyEmail() {
        return this.createAndValidateProperty(RegexPatterns.EMAIL, "foo@bar" + this.random.nextInt() + ".com");
    }

    @Override
    public T anyUrl() {
        return this.createAndValidateProperty(RegexPatterns.URL, "https://foo" + this.random.nextInt() + ".com");
    }

    @Override
    public T anyHttpsUrl() {
        return this.createAndValidateProperty(RegexPatterns.HTTPS_URL, "https://baz" + this.random.nextInt() + ".com");
    }

    @Override
    public T anyUuid() {
        return this.createAndValidateProperty(RegexPatterns.UUID, UUID.randomUUID().toString());
    }

    @Override
    public T anyDate() {
        int d = this.random.nextInt(8) + 1;
        return this.createAndValidateProperty(RegexPatterns.ANY_DATE, "201" + String.valueOf(d) + "-0" + String.valueOf(d) + "-1" + String.valueOf(d));
    }

    @Override
    public T anyDateTime() {
        int d = this.random.nextInt(8) + 1;
        return this.createAndValidateProperty(RegexPatterns.ANY_DATE_TIME, "201" + String.valueOf(d) + "-0" + String.valueOf(d) + "-1" + String.valueOf(d) + "T12:23:34");
    }

    @Override
    public T anyTime() {
        int d = this.random.nextInt(9);
        return this.createAndValidateProperty(RegexPatterns.ANY_TIME, "12:2" + String.valueOf(d) + ":3" + String.valueOf(d));
    }

    @Override
    public T anyIso8601WithOffset() {
        int d = this.random.nextInt(8) + 1;
        return this.createAndValidateProperty(RegexPatterns.ISO8601_WITH_OFFSET, "201" + String.valueOf(d) + "-0" + String.valueOf(d) + "-1" + String.valueOf(d) + "T12:23:34.123Z");
    }

    @Override
    public T anyNonBlankString() {
        return this.createAndValidateProperty(RegexPatterns.NON_BLANK, RandomStringGenerator.randomString(20));
    }

    @Override
    public T anyNonEmptyString() {
        return this.createAndValidateProperty(RegexPatterns.NON_EMPTY, RandomStringGenerator.randomString(20));
    }

    @Override
    public T anyOf(String ... values) {
        return this.createAndValidateProperty(RegexPatterns.anyOf(values), values[0]);
    }
}

