/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.repository.internal;

import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.util.ConfigUtils;
import shaded.org.apache.maven.repository.internal.PluginsMetadata;
import shaded.org.eclipse.aether.impl.MetadataGenerator;

class PluginsMetadataGenerator
implements MetadataGenerator {
    private static final String PLUGIN_DESCRIPTOR_LOCATION = "META-INF/maven/plugin.xml";
    private final Map<Object, PluginsMetadata> processedPlugins = new LinkedHashMap<Object, PluginsMetadata>();
    private final Date timestamp;

    PluginsMetadataGenerator(RepositorySystemSession session, InstallRequest request) {
        this(session, request.getMetadata());
    }

    PluginsMetadataGenerator(RepositorySystemSession session, DeployRequest request) {
        this(session, request.getMetadata());
    }

    private PluginsMetadataGenerator(RepositorySystemSession session, Collection<? extends Metadata> metadatas) {
        this.timestamp = (Date)ConfigUtils.getObject(session, (Object)new Date(), "maven.startTime");
        Iterator<? extends Metadata> it = metadatas.iterator();
        while (it.hasNext()) {
            Metadata metadata = it.next();
            if (!(metadata instanceof PluginsMetadata)) continue;
            it.remove();
            PluginsMetadata pluginMetadata = (PluginsMetadata)metadata;
            this.processedPlugins.put(pluginMetadata.getGroupId(), pluginMetadata);
        }
    }

    @Override
    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }

    @Override
    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    @Override
    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        LinkedHashMap<String, PluginsMetadata> plugins = new LinkedHashMap<String, PluginsMetadata>();
        for (Artifact artifact : artifacts) {
            PluginsMetadata pluginMetadata;
            String key;
            PluginsMetadata.PluginInfo pluginInfo = this.extractPluginInfo(artifact);
            if (pluginInfo == null || this.processedPlugins.get(key = pluginInfo.groupId) != null || (pluginMetadata = (PluginsMetadata)plugins.get(key)) != null) continue;
            pluginMetadata = new PluginsMetadata(pluginInfo, this.timestamp);
            plugins.put(key, pluginMetadata);
        }
        return plugins.values();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private PluginsMetadata.PluginInfo extractPluginInfo(Artifact artifact) {
        block14: {
            Path artifactPath;
            if (artifact != null && "jar".equals(artifact.getExtension()) && "".equals(artifact.getClassifier()) && artifact.getFile() != null && Files.isRegularFile(artifactPath = artifact.getFile().toPath(), new LinkOption[0])) {
                try (JarFile artifactJar = new JarFile(artifactPath.toFile(), false);){
                    PluginsMetadata.PluginInfo pluginInfo;
                    block15: {
                        ZipEntry pluginDescriptorEntry = artifactJar.getEntry(PLUGIN_DESCRIPTOR_LOCATION);
                        if (pluginDescriptorEntry == null) break block14;
                        XmlStreamReader reader = ReaderFactory.newXmlReader(artifactJar.getInputStream(pluginDescriptorEntry));
                        try {
                            Xpp3Dom root = Xpp3DomBuilder.build(reader);
                            String groupId = root.getChild("groupId").getValue();
                            String artifactId = root.getChild("artifactId").getValue();
                            String goalPrefix = root.getChild("goalPrefix").getValue();
                            String name = root.getChild("name").getValue();
                            pluginInfo = new PluginsMetadata.PluginInfo(groupId, artifactId, goalPrefix, name);
                            if (reader == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        ((Reader)reader).close();
                    }
                    return pluginInfo;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

