/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.4.0,
 any modifications will be overwritten.
 ==============================================================
 */

package shaded.org.apache.maven.settings;

/**
 * 
 *         A download mirror for a given repository.
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Mirror
    extends IdentifiableBase
    implements java.io.Serializable, java.lang.Cloneable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             
     *             A repository id or (since Maven 2.0.9) an
     * expression matching one or many repository ids to mirror,
     * e.g.,
     *             <code>central</code> or <code>*,!repo1</code>.
     *             <code>*</code> (since Maven 2.0.5),
     * <code>external:*</code> (since Maven 2.0.9) and
     * <code>external:http:*</code> (since Maven 3.8.0) have
     *             a special meaning: see <a
     * href="/guides/mini/guide-mirror-settings.html">Mirror
     * Settings</a> guide.
     *             
     *           
     */
    private String mirrorOf;

    /**
     * 
     *             The optional name that describes the mirror.
     *           
     */
    private String name;

    /**
     * The URL of the mirror repository.
     */
    private String url;

    /**
     * 
     *             
     *             The layout of the mirror repository.
     *             <br><b>Since</b>: Maven 3
     *             
     *           .
     */
    private String layout = "default";

    /**
     * 
     *             
     *             The layouts of repositories being mirrored. This
     * value can be used to restrict the usage
     *             of the mirror to repositories with a matching
     * layout (apart from a matching id).
     *             <br><b>Since</b>: Maven 3
     *             
     *           .
     */
    private String mirrorOfLayouts = "default,legacy";

    /**
     * 
     *             
     *             Whether this mirror should be blocked from any
     * download request but fail the download process, explaining
     * why.
     *             <br><b>Default value is</b>: <code>false</code>
     *             <br><b>Since</b>: Maven 3.8.0
     *             
     *           .
     */
    private boolean blocked = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method clone.
     * 
     * @return Mirror
     */
    public Mirror clone()
    {
        try
        {
            Mirror copy = (Mirror) super.clone();

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- Mirror clone()

    /**
     * Get the layout of the mirror repository.
     *             <br><b>Since</b>: Maven 3.
     * 
     * @return String
     */
    public String getLayout()
    {
        return this.layout;
    } //-- String getLayout()

    /**
     * Get a repository id or (since Maven 2.0.9) an expression
     * matching one or many repository ids to mirror, e.g.,
     *             <code>central</code> or <code>*,!repo1</code>.
     *             <code>*</code> (since Maven 2.0.5),
     * <code>external:*</code> (since Maven 2.0.9) and
     * <code>external:http:*</code> (since Maven 3.8.0) have
     *             a special meaning: see <a
     * href="/guides/mini/guide-mirror-settings.html">Mirror
     * Settings</a> guide.
     * 
     * @return String
     */
    public String getMirrorOf()
    {
        return this.mirrorOf;
    } //-- String getMirrorOf()

    /**
     * Get the layouts of repositories being mirrored. This value
     * can be used to restrict the usage
     *             of the mirror to repositories with a matching
     * layout (apart from a matching id).
     *             <br><b>Since</b>: Maven 3.
     * 
     * @return String
     */
    public String getMirrorOfLayouts()
    {
        return this.mirrorOfLayouts;
    } //-- String getMirrorOfLayouts()

    /**
     * Get the optional name that describes the mirror.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Get the URL of the mirror repository.
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Get whether this mirror should be blocked from any download
     * request but fail the download process, explaining why.
     *             <br><b>Default value is</b>: <code>false</code>
     *             <br><b>Since</b>: Maven 3.8.0.
     * 
     * @return boolean
     */
    public boolean isBlocked()
    {
        return this.blocked;
    } //-- boolean isBlocked()

    /**
     * Set whether this mirror should be blocked from any download
     * request but fail the download process, explaining why.
     *             <br><b>Default value is</b>: <code>false</code>
     *             <br><b>Since</b>: Maven 3.8.0.
     * 
     * @param blocked a blocked object.
     */
    public void setBlocked( boolean blocked )
    {
        this.blocked = blocked;
    } //-- void setBlocked( boolean )

    /**
     * Set the layout of the mirror repository.
     *             <br><b>Since</b>: Maven 3.
     * 
     * @param layout a layout object.
     */
    public void setLayout( String layout )
    {
        this.layout = layout;
    } //-- void setLayout( String )

    /**
     * Set a repository id or (since Maven 2.0.9) an expression
     * matching one or many repository ids to mirror, e.g.,
     *             <code>central</code> or <code>*,!repo1</code>.
     *             <code>*</code> (since Maven 2.0.5),
     * <code>external:*</code> (since Maven 2.0.9) and
     * <code>external:http:*</code> (since Maven 3.8.0) have
     *             a special meaning: see <a
     * href="/guides/mini/guide-mirror-settings.html">Mirror
     * Settings</a> guide.
     * 
     * @param mirrorOf a mirrorOf object.
     */
    public void setMirrorOf( String mirrorOf )
    {
        this.mirrorOf = mirrorOf;
    } //-- void setMirrorOf( String )

    /**
     * Set the layouts of repositories being mirrored. This value
     * can be used to restrict the usage
     *             of the mirror to repositories with a matching
     * layout (apart from a matching id).
     *             <br><b>Since</b>: Maven 3.
     * 
     * @param mirrorOfLayouts a mirrorOfLayouts object.
     */
    public void setMirrorOfLayouts( String mirrorOfLayouts )
    {
        this.mirrorOfLayouts = mirrorOfLayouts;
    } //-- void setMirrorOfLayouts( String )

    /**
     * Set the optional name that describes the mirror.
     * 
     * @param name a name object.
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set the URL of the mirror repository.
     * 
     * @param url a url object.
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )

    
            

    public String toString()
    {
        StringBuilder sb = new StringBuilder( 128 );
        sb.append( "Mirror[" );
        sb.append( "id=" ).append( this.getId() );
        sb.append( ",mirrorOf=" ).append( mirrorOf );
        sb.append( ",url=" ).append( this.url );
        sb.append( ",name=" ).append( this.name );
        if ( isBlocked() )
        {
            sb.append( ",blocked" );
        }
        sb.append( "]" );
        return sb.toString();
    }
            
          
}
