/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.4.0,
 any modifications will be overwritten.
 ==============================================================
 */

package shaded.org.apache.maven.model;

/**
 * The conditions within the build runtime environment which will
 * trigger the
 *         automatic inclusion of the build profile. Multiple
 * conditions can be defined, which must
 *         be all satisfied to activate the profile.
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Activation
    implements java.io.Serializable, java.lang.Cloneable, shaded.org.apache.maven.model.InputLocationTracker
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * If set to true, this profile will be active unless another
     * profile in this
     *             pom is activated using the command line -P
     * option or by one of that profile's
     *             activators.
     */
    private boolean activeByDefault = false;

    /**
     * 
     *             
     *             Specifies that this profile will be activated
     * when a matching JDK is detected.
     *             For example, <code>1.4</code> only activates on
     * JDKs versioned 1.4,
     *             while <code>!1.4</code> matches any JDK that is
     * not version 1.4. Ranges are supported too:
     *             <code>[1.5,)</code> activates when the JDK is
     * 1.5 minimum.
     *             
     *           
     */
    private String jdk;

    /**
     * Specifies that this profile will be activated when matching
     * operating system
     *             attributes are detected.
     */
    private ActivationOS os;

    /**
     * Specifies that this profile will be activated when this
     * property is
     *             specified.
     */
    private ActivationProperty property;

    /**
     * Specifies that this profile will be activated based on
     * existence of a file.
     */
    private ActivationFile file;

    /**
     * Field locations.
     */
    private java.util.Map<Object, InputLocation> locations;

    /**
     * Field location.
     */
    private InputLocation location;

    /**
     * Field activeByDefaultLocation.
     */
    private InputLocation activeByDefaultLocation;

    /**
     * Field jdkLocation.
     */
    private InputLocation jdkLocation;

    /**
     * Field osLocation.
     */
    private InputLocation osLocation;

    /**
     * Field propertyLocation.
     */
    private InputLocation propertyLocation;

    /**
     * Field fileLocation.
     */
    private InputLocation fileLocation;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method clone.
     * 
     * @return Activation
     */
    public Activation clone()
    {
        try
        {
            Activation copy = (Activation) super.clone();

            if ( this.os != null )
            {
                copy.os = (ActivationOS) this.os.clone();
            }

            if ( this.property != null )
            {
                copy.property = (ActivationProperty) this.property.clone();
            }

            if ( this.file != null )
            {
                copy.file = (ActivationFile) this.file.clone();
            }

            if ( copy.locations != null )
            {
                copy.locations = new java.util.LinkedHashMap( copy.locations );
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- Activation clone()

    /**
     * Get specifies that this profile will be activated based on
     * existence of a file.
     * 
     * @return ActivationFile
     */
    public ActivationFile getFile()
    {
        return this.file;
    } //-- ActivationFile getFile()

    /**
     * Get specifies that this profile will be activated when a
     * matching JDK is detected.
     *             For example, <code>1.4</code> only activates on
     * JDKs versioned 1.4,
     *             while <code>!1.4</code> matches any JDK that is
     * not version 1.4. Ranges are supported too:
     *             <code>[1.5,)</code> activates when the JDK is
     * 1.5 minimum.
     * 
     * @return String
     */
    public String getJdk()
    {
        return this.jdk;
    } //-- String getJdk()

    /**
     * 
     * 
     * @param key a key object.
     * @return InputLocation
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "" :
                {
                    return this.location;
                }
                case "activeByDefault" :
                {
                    return activeByDefaultLocation;
                }
                case "jdk" :
                {
                    return jdkLocation;
                }
                case "os" :
                {
                    return osLocation;
                }
                case "property" :
                {
                    return propertyLocation;
                }
                case "file" :
                {
                    return fileLocation;
                }
                default :
                {
                    return getOtherLocation( key );
                }
                }
            }
            else
            {
                return getOtherLocation( key );
            }
    } //-- InputLocation getLocation( Object )

    /**
     * Get specifies that this profile will be activated when
     * matching operating system
     *             attributes are detected.
     * 
     * @return ActivationOS
     */
    public ActivationOS getOs()
    {
        return this.os;
    } //-- ActivationOS getOs()

    /**
     * 
     * 
     * @param key a key object.
     * @param location a location object.
     */
    public void setLocation( Object key, InputLocation location )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "" :
                {
                    this.location = location;
                    return;
                }
                case "activeByDefault" :
                {
                    activeByDefaultLocation = location;
                    return;
                }
                case "jdk" :
                {
                    jdkLocation = location;
                    return;
                }
                case "os" :
                {
                    osLocation = location;
                    return;
                }
                case "property" :
                {
                    propertyLocation = location;
                    return;
                }
                case "file" :
                {
                    fileLocation = location;
                    return;
                }
                default :
                {
                    setOtherLocation( key, location );
                    return;
                }
            }
        }
        else
        {
            setOtherLocation( key, location );
        }
    } //-- void setLocation( Object, InputLocation )

    /**
     * 
     * 
     * @param key a key object.
     * @param location a location object.
     */
    public void setOtherLocation( Object key, InputLocation location )
    {
        if ( location != null )
        {
            if ( this.locations == null )
            {
                this.locations = new java.util.LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put( key, location );
        }
    } //-- void setOtherLocation( Object, InputLocation )

    /**
     * 
     * 
     * @param key a key object.
     * @return InputLocation
     */
    private InputLocation getOtherLocation( Object key )
    {
        return ( locations != null ) ? locations.get( key ) : null;
    } //-- InputLocation getOtherLocation( Object )

    /**
     * Get specifies that this profile will be activated when this
     * property is
     *             specified.
     * 
     * @return ActivationProperty
     */
    public ActivationProperty getProperty()
    {
        return this.property;
    } //-- ActivationProperty getProperty()

    /**
     * Get if set to true, this profile will be active unless
     * another profile in this
     *             pom is activated using the command line -P
     * option or by one of that profile's
     *             activators.
     * 
     * @return boolean
     */
    public boolean isActiveByDefault()
    {
        return this.activeByDefault;
    } //-- boolean isActiveByDefault()

    /**
     * Set if set to true, this profile will be active unless
     * another profile in this
     *             pom is activated using the command line -P
     * option or by one of that profile's
     *             activators.
     * 
     * @param activeByDefault a activeByDefault object.
     */
    public void setActiveByDefault( boolean activeByDefault )
    {
        this.activeByDefault = activeByDefault;
    } //-- void setActiveByDefault( boolean )

    /**
     * Set specifies that this profile will be activated based on
     * existence of a file.
     * 
     * @param file a file object.
     */
    public void setFile( ActivationFile file )
    {
        this.file = file;
    } //-- void setFile( ActivationFile )

    /**
     * Set specifies that this profile will be activated when a
     * matching JDK is detected.
     *             For example, <code>1.4</code> only activates on
     * JDKs versioned 1.4,
     *             while <code>!1.4</code> matches any JDK that is
     * not version 1.4. Ranges are supported too:
     *             <code>[1.5,)</code> activates when the JDK is
     * 1.5 minimum.
     * 
     * @param jdk a jdk object.
     */
    public void setJdk( String jdk )
    {
        this.jdk = jdk;
    } //-- void setJdk( String )

    /**
     * Set specifies that this profile will be activated when
     * matching operating system
     *             attributes are detected.
     * 
     * @param os a os object.
     */
    public void setOs( ActivationOS os )
    {
        this.os = os;
    } //-- void setOs( ActivationOS )

    /**
     * Set specifies that this profile will be activated when this
     * property is
     *             specified.
     * 
     * @param property a property object.
     */
    public void setProperty( ActivationProperty property )
    {
        this.property = property;
    } //-- void setProperty( ActivationProperty )

}
