/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.transport.http;

import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import shaded.org.eclipse.aether.transport.http.SslConfig;
import shaded.org.eclipse.aether.transport.http.X509HostnameVerifierAdapter;

final class SslSocketFactory
extends org.apache.http.conn.ssl.SSLSocketFactory {
    private final String[] cipherSuites;
    private final String[] protocols;

    SslSocketFactory(SslConfig config) {
        this(SslSocketFactory.getSocketFactory(config.context), SslSocketFactory.getHostnameVerifier(config.verifier), config.cipherSuites, config.protocols);
    }

    private static SSLSocketFactory getSocketFactory(SSLContext context) {
        return context != null ? context.getSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    private static X509HostnameVerifier getHostnameVerifier(HostnameVerifier verifier) {
        return verifier != null ? X509HostnameVerifierAdapter.adapt(verifier) : org.apache.http.conn.ssl.SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
    }

    private SslSocketFactory(SSLSocketFactory socketfactory, X509HostnameVerifier hostnameVerifier, String[] cipherSuites, String[] protocols) {
        super(socketfactory, hostnameVerifier);
        this.cipherSuites = cipherSuites;
        this.protocols = protocols;
    }

    @Override
    protected void prepareSocket(SSLSocket socket) throws IOException {
        super.prepareSocket(socket);
        if (this.cipherSuites != null) {
            socket.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.protocols != null) {
            socket.setEnabledProtocols(this.protocols);
        }
    }
}

