/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.settings.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.apache.maven.settings.io.SettingsWriter;
import shaded.org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;

@Component(role=SettingsWriter.class)
public class DefaultSettingsWriter
implements SettingsWriter {
    @Override
    public void write(File output, Map<String, Object> options, Settings settings) throws IOException {
        Validate.notNull(output, "output cannot be null", new Object[0]);
        Validate.notNull(settings, "settings cannot be null", new Object[0]);
        output.getParentFile().mkdirs();
        this.write(WriterFactory.newXmlWriter(output), options, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer output, Map<String, Object> options, Settings settings) throws IOException {
        Validate.notNull(output, "output cannot be null", new Object[0]);
        Validate.notNull(settings, "settings cannot be null", new Object[0]);
        try {
            SettingsXpp3Writer w = new SettingsXpp3Writer();
            w.write(output, settings);
        }
        finally {
            IOUtil.close(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream output, Map<String, Object> options, Settings settings) throws IOException {
        Validate.notNull(output, "output cannot be null", new Object[0]);
        Validate.notNull(settings, "settings cannot be null", new Object[0]);
        try {
            String encoding = settings.getModelEncoding();
            if (encoding == null || encoding.length() <= 0) {
                encoding = "UTF-8";
            }
            this.write(new OutputStreamWriter(output, encoding), options, settings);
        }
        finally {
            IOUtil.close(output);
        }
    }
}

