/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import shaded.org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManager;
import shaded.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import shaded.org.eclipse.aether.spi.locator.Service;
import shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import shaded.org.eclipse.aether.spi.log.Logger;
import shaded.org.eclipse.aether.spi.log.LoggerFactory;
import shaded.org.eclipse.aether.spi.log.NullLoggerFactory;

@Named(value="enhanced")
public class EnhancedLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private float priority = 10.0f;

    public EnhancedLocalRepositoryManagerFactory() {
    }

    @Inject
    EnhancedLocalRepositoryManagerFactory(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public LocalRepositoryManager newInstance(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        if ("".equals(repository.getContentType()) || "default".equals(repository.getContentType())) {
            return new EnhancedLocalRepositoryManager(repository.getBasedir(), session).setLogger(this.logger);
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public EnhancedLocalRepositoryManagerFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, EnhancedLocalRepositoryManager.class);
        return this;
    }

    public float getPriority() {
        return this.priority;
    }

    public EnhancedLocalRepositoryManagerFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

