/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.springframework.cloud.contract.stubrunner.ContractProjectUpdater;
import org.springframework.cloud.contract.stubrunner.ScmStubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.util.StringUtils;

class PublishStubsToScmTask
extends DefaultTask {
    static final String TASK_NAME = "publishStubsToScm";
    private final Repository contractRepository;
    private final Property<StubRunnerProperties.StubsMode> contractsMode;
    private final Property<Boolean> deleteStubsAfterTest;
    private final Property<Boolean> failOnNoContracts;
    private final MapProperty<String, String> contractsProperties;
    private final DirectoryProperty stubsDir;
    private final Property<String> projectGroup;
    private final Property<String> projectName;
    private final Property<String> projectVersion;

    @Inject
    public PublishStubsToScmTask(ObjectFactory objects, ProviderFactory providers) {
        this.contractRepository = (Repository)objects.newInstance(Repository.class, new Object[0]);
        this.contractsMode = objects.property(StubRunnerProperties.StubsMode.class);
        this.deleteStubsAfterTest = objects.property(Boolean.class);
        this.failOnNoContracts = objects.property(Boolean.class);
        this.contractsProperties = objects.mapProperty(String.class, String.class);
        this.stubsDir = objects.directoryProperty();
        this.projectGroup = objects.property(String.class).convention(providers.provider(() -> this.getProject().getGroup().toString()));
        this.projectName = objects.property(String.class).convention(providers.provider(() -> this.getProject().getName()));
        this.projectVersion = objects.property(String.class).convention(providers.provider(() -> this.getProject().getVersion().toString()));
        this.onlyIf(task -> {
            String contractRepoUrl = (String)this.contractRepository.repositoryUrl.getOrElse((Object)"");
            if (!StringUtils.hasText((String)contractRepoUrl) || !ScmStubDownloaderBuilder.isProtocolAccepted((String)contractRepoUrl)) {
                this.getLogger().warn("Skipping pushing stubs to scm since your contracts repository URL [{}] doesn't match any of the accepted protocols for SCM stub downloader", (Object)contractRepoUrl);
                return false;
            }
            return true;
        });
    }

    @TaskAction
    void publishStubsToScm() {
        String projectGroupNameVersion = (String)this.projectGroup.get() + ":" + (String)this.projectName.get() + ":" + (String)this.projectVersion.get();
        this.getLogger().info("Pushing Stubs to SCM for project [{}]", (Object)projectGroupNameVersion);
        StubRunnerOptions stubRunnerOptions = this.createStubRunnerOptions();
        new ContractProjectUpdater(stubRunnerOptions).updateContractProject(projectGroupNameVersion, ((Directory)this.stubsDir.get()).getAsFile().toPath());
    }

    @Nested
    Repository getContractRepository() {
        return this.contractRepository;
    }

    @Input
    Property<StubRunnerProperties.StubsMode> getContractsMode() {
        return this.contractsMode;
    }

    @Input
    Property<Boolean> getDeleteStubsAfterTest() {
        return this.deleteStubsAfterTest;
    }

    @Input
    Property<Boolean> getFailOnNoContracts() {
        return this.failOnNoContracts;
    }

    @Input
    MapProperty<String, String> getContractsProperties() {
        return this.contractsProperties;
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    DirectoryProperty getStubsDir() {
        return this.stubsDir;
    }

    private StubRunnerOptions createStubRunnerOptions() {
        StubRunnerOptionsBuilder options = new StubRunnerOptionsBuilder().withOptions(StubRunnerOptions.fromSystemProps()).withStubRepositoryRoot((String)this.contractRepository.repositoryUrl.getOrNull()).withStubsMode((StubRunnerProperties.StubsMode)this.contractsMode.get()).withUsername((String)this.contractRepository.username.getOrNull()).withPassword((String)this.contractRepository.password.getOrNull()).withDeleteStubsAfterTest(((Boolean)this.deleteStubsAfterTest.get()).booleanValue()).withProperties((Map)this.contractsProperties.getOrNull()).withFailOnNoStubs(((Boolean)this.failOnNoContracts.get()).booleanValue());
        if (this.contractRepository.proxyPort.isPresent()) {
            options = options.withProxy((String)this.contractRepository.proxyHost.getOrNull(), ((Integer)this.contractRepository.proxyPort.get()).intValue());
        }
        return options.build();
    }

    @Input
    protected Property<String> getProjectGroup() {
        return this.projectGroup;
    }

    @Input
    protected Property<String> getProjectName() {
        return this.projectName;
    }

    @Input
    protected Property<String> getProjectVersion() {
        return this.projectVersion;
    }

    static class Repository {
        private final Property<String> repositoryUrl;
        private final Property<String> username;
        private final Property<String> password;
        private final Property<Integer> proxyPort;
        private final Property<String> proxyHost;

        @Inject
        public Repository(ObjectFactory objects) {
            this.repositoryUrl = objects.property(String.class);
            this.username = objects.property(String.class);
            this.password = objects.property(String.class);
            this.proxyHost = objects.property(String.class);
            this.proxyPort = objects.property(Integer.class);
        }

        @Input
        @Optional
        Property<String> getRepositoryUrl() {
            return this.repositoryUrl;
        }

        @Input
        @Optional
        Property<String> getUsername() {
            return this.username;
        }

        @Input
        @Optional
        Property<String> getPassword() {
            return this.password;
        }

        @Input
        @Optional
        Property<Integer> getProxyPort() {
            return this.proxyPort;
        }

        @Input
        @Optional
        Property<String> getProxyHost() {
            return this.proxyHost;
        }
    }
}

