/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.plugin.ContractVerifierExtension;
import org.springframework.cloud.contract.verifier.plugin.ContractsCopyTask;
import org.springframework.cloud.contract.verifier.plugin.GenerateClientStubsFromDslTask;
import org.springframework.cloud.contract.verifier.plugin.GenerateServerTestsTask;
import org.springframework.cloud.contract.verifier.plugin.PublishStubsToScmTask;
import org.springframework.cloud.contract.verifier.plugin.VersionExtractor;

public class SpringCloudContractVerifierGradlePlugin
implements Plugin<Project> {
    private static final String SPRING_CLOUD_VERSION = VersionExtractor.forClass(SpringCloudContractVerifierGradlePlugin.class);
    private static final String GROUP_NAME = "Verification";
    private static final String EXTENSION_NAME = "contracts";
    private static final String CONTRACT_TEST_SOURCE_SET_NAME = "contractTest";
    private static final String CONTRACT_TEST_COMPILE_ONLY_CONFIGURATION_NAME = "contractTestCompileOnly";
    private static final String CONTRACT_TEST_IMPLEMENTATION_CONFIGURATION_NAME = "contractTestImplementation";
    private static final String CONTRACT_TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "contractTestRuntimeOnly";
    private static final String CONTRACT_TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "contractTestRuntimeClasspath";
    private static final String CONTRACT_TEST_GENERATOR_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "contractTestGeneratorRuntimeClasspath";
    private static final String VERIFIER_STUBS_JAR_TASK_NAME = "verifierStubsJar";
    private static final String CONTRACT_TEST_TASK_NAME = "contractTest";
    private Project project;

    public void apply(Project project) {
        this.project = project;
        project.getPlugins().apply(JavaPlugin.class);
        ContractVerifierExtension extension = (ContractVerifierExtension)project.getExtensions().create(EXTENSION_NAME, ContractVerifierExtension.class, new Object[0]);
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet contractTestSourceSet = this.configureSourceSets(extension, javaConvention);
        this.configureConfigurations();
        this.registerContractTestTask(contractTestSourceSet);
        TaskProvider<ContractsCopyTask> copyContracts = this.createAndConfigureCopyContractsTask(extension);
        TaskProvider<GenerateClientStubsFromDslTask> generateClientStubs = this.createAndConfigureGenerateClientStubs(extension, copyContracts);
        this.createAndConfigureStubsJarTasks(extension, generateClientStubs);
        this.createGenerateTestsTask(extension, contractTestSourceSet, copyContracts);
        this.createAndConfigurePublishStubsToScmTask(extension, generateClientStubs);
        project.getDependencies().add(CONTRACT_TEST_GENERATOR_RUNTIME_CLASSPATH_CONFIGURATION_NAME, (Object)("org.springframework.cloud:spring-cloud-contract-converters:" + SPRING_CLOUD_VERSION));
        project.afterEvaluate(inner -> {
            DirectoryProperty generatedTestSourcesDir = extension.getGeneratedTestSourcesDir();
            if (generatedTestSourcesDir.isPresent()) {
                if (extension.getTestFramework().get() == TestFramework.SPOCK) {
                    project.getPlugins().withType(GroovyPlugin.class, groovyPlugin -> {
                        GroovySourceSet groovy = (GroovySourceSet)((HasConvention)contractTestSourceSet).getConvention().getPlugin(GroovySourceSet.class);
                        groovy.getGroovy().srcDirs(new Object[]{generatedTestSourcesDir});
                    });
                } else {
                    contractTestSourceSet.getJava().srcDirs(new Object[]{generatedTestSourcesDir});
                }
            }
        });
    }

    private SourceSet configureSourceSets(ContractVerifierExtension extension, JavaPluginConvention javaConvention) {
        SourceSetContainer sourceSets = javaConvention.getSourceSets();
        SourceSet contractTest = (SourceSet)sourceSets.create("contractTest");
        contractTest.getJava().srcDirs(new Object[]{extension.getGeneratedTestJavaSourcesDir()});
        this.project.getPlugins().withType(GroovyPlugin.class, groovyPlugin -> {
            GroovySourceSet groovy = (GroovySourceSet)((HasConvention)contractTest).getConvention().getPlugin(GroovySourceSet.class);
            groovy.getGroovy().srcDirs(new Object[]{extension.getGeneratedTestGroovySourcesDir()});
        });
        contractTest.getResources().srcDirs(new Object[]{extension.getGeneratedTestResourcesDir()});
        SourceSetOutput mainOutput = ((SourceSet)sourceSets.getByName("main")).getOutput();
        SourceSetOutput testOutput = ((SourceSet)sourceSets.getByName("test")).getOutput();
        FileCollection compileClasspath = contractTest.getCompileClasspath();
        contractTest.setCompileClasspath(compileClasspath.plus((FileCollection)mainOutput).plus((FileCollection)testOutput));
        FileCollection runtimeClasspath = contractTest.getRuntimeClasspath();
        contractTest.setRuntimeClasspath(runtimeClasspath.plus((FileCollection)mainOutput).plus((FileCollection)testOutput));
        return contractTest;
    }

    private void configureConfigurations() {
        ConfigurationContainer configurations = this.project.getConfigurations();
        Configuration testCompileOnly = configurations.getByName("testCompileOnly");
        Configuration testImplementation = configurations.getByName("testImplementation");
        Configuration testRuntimeOnly = configurations.getByName("testRuntimeOnly");
        Configuration contractTestCompileOnly = configurations.getByName(CONTRACT_TEST_COMPILE_ONLY_CONFIGURATION_NAME);
        Configuration contractTestImplementation = configurations.getByName(CONTRACT_TEST_IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration contractTestRuntimeOnly = configurations.getByName(CONTRACT_TEST_RUNTIME_ONLY_CONFIGURATION_NAME);
        contractTestCompileOnly.extendsFrom(new Configuration[]{testCompileOnly});
        contractTestImplementation.extendsFrom(new Configuration[]{testImplementation});
        contractTestRuntimeOnly.extendsFrom(new Configuration[]{testRuntimeOnly});
        configurations.create(CONTRACT_TEST_GENERATOR_RUNTIME_CLASSPATH_CONFIGURATION_NAME, conf -> {
            conf.setVisible(false);
            conf.setCanBeResolved(true);
            conf.setCanBeConsumed(false);
            conf.attributes(attributes -> {
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)this.project.getObjects().named(Usage.class, "java-runtime"));
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)this.project.getObjects().named(Category.class, "library"));
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)this.project.getObjects().named(LibraryElements.class, "jar"));
                attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)this.project.getObjects().named(Bundling.class, "external"));
            });
            conf.extendsFrom(new Configuration[]{configurations.getByName(CONTRACT_TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME)});
        });
    }

    private void registerContractTestTask(SourceSet contractTestSourceSet) {
        TaskProvider contractTestTask = this.project.getTasks().register("contractTest", Test.class, contractTest -> {
            contractTest.setDescription("Runs the contract tests");
            contractTest.setGroup(GROUP_NAME);
            contractTest.setTestClassesDirs(contractTestSourceSet.getOutput().getClassesDirs());
            contractTest.setClasspath(contractTestSourceSet.getRuntimeClasspath());
            contractTest.mustRunAfter(new Object[]{this.project.getTasks().named("test")});
        });
        this.project.getTasks().named("check", check -> check.dependsOn(new Object[]{contractTestTask}));
    }

    private void createGenerateTestsTask(ContractVerifierExtension extension, SourceSet contractTestSourceSet, TaskProvider<ContractsCopyTask> copyContracts) {
        TaskProvider task = this.project.getTasks().register("generateContractTests", GenerateServerTestsTask.class);
        task.configure(generateServerTestsTask -> {
            generateServerTestsTask.setDescription("Generate server tests from the contracts");
            generateServerTestsTask.setGroup(GROUP_NAME);
            generateServerTestsTask.getContractsDslDir().convention(copyContracts.flatMap(ContractsCopyTask::getCopiedContractsFolder));
            generateServerTestsTask.getNameSuffixForTests().convention(extension.getNameSuffixForTests());
            generateServerTestsTask.getBasePackageForTests().convention(extension.getBasePackageForTests());
            generateServerTestsTask.getBaseClassForTests().convention(extension.getBaseClassForTests());
            generateServerTestsTask.getPackageWithBaseClasses().convention(extension.getPackageWithBaseClasses());
            generateServerTestsTask.getExcludedFiles().convention(extension.getExcludedFiles());
            generateServerTestsTask.getIgnoredFiles().convention(extension.getIgnoredFiles());
            generateServerTestsTask.getIncludedFiles().convention(extension.getIncludedFiles());
            generateServerTestsTask.getImports().convention(extension.getImports());
            generateServerTestsTask.getStaticImports().convention(extension.getStaticImports());
            generateServerTestsTask.getTestMode().convention(extension.getTestMode());
            generateServerTestsTask.getTestFramework().convention(extension.getTestFramework());
            generateServerTestsTask.getBaseClassMappings().convention(extension.getBaseClassMappings().getBaseClassMappings());
            generateServerTestsTask.getAssertJsonSize().convention(extension.getAssertJsonSize());
            generateServerTestsTask.getFailOnInProgress().convention(extension.getFailOnInProgress());
            generateServerTestsTask.getClasspath().from(new Object[]{this.project.getConfigurations().getByName(CONTRACT_TEST_GENERATOR_RUNTIME_CLASSPATH_CONFIGURATION_NAME)});
            generateServerTestsTask.getGeneratedTestSourcesDir().convention(extension.getTestFramework().flatMap(testFramework -> {
                DirectoryProperty correctSourceSetDir = testFramework == TestFramework.SPOCK ? extension.getGeneratedTestGroovySourcesDir() : extension.getGeneratedTestJavaSourcesDir();
                return extension.getGeneratedTestSourcesDir().orElse((Provider)correctSourceSetDir);
            }));
            generateServerTestsTask.getGeneratedTestResourcesDir().convention((Provider)extension.getGeneratedTestResourcesDir());
            generateServerTestsTask.dependsOn(new Object[]{copyContracts});
        });
        this.project.getTasks().named(contractTestSourceSet.getProcessResourcesTaskName(), processContractTestResourcesTask -> processContractTestResourcesTask.dependsOn(new Object[]{task}));
        this.project.getTasks().named(contractTestSourceSet.getCompileJavaTaskName(), compileContractTestJava -> compileContractTestJava.dependsOn(new Object[]{task}));
        this.project.getPlugins().withType(GroovyPlugin.class, groovyPlugin -> this.project.getTasks().named(contractTestSourceSet.getCompileTaskName("groovy"), compileContractTestGroovy -> compileContractTestGroovy.dependsOn(new Object[]{task})));
        this.project.getPlugins().withId("kotlin", kotlinPlugin -> this.project.getTasks().named(contractTestSourceSet.getCompileTaskName("kotlin"), compileContractTestKotlin -> compileContractTestKotlin.dependsOn(new Object[]{task})));
        this.project.getPlugins().withId("org.jetbrains.kotlin.jvm", kotlinJvmPlugin -> this.project.getTasks().named(contractTestSourceSet.getCompileTaskName("kotlin"), compileContractTestKotlin -> compileContractTestKotlin.dependsOn(new Object[]{task})));
    }

    private void createAndConfigurePublishStubsToScmTask(ContractVerifierExtension extension, TaskProvider<GenerateClientStubsFromDslTask> generateClientStubs) {
        TaskProvider task = this.project.getTasks().register("publishStubsToScm", PublishStubsToScmTask.class);
        task.configure(publishStubsToScmTask -> {
            publishStubsToScmTask.setDescription("The generated stubs get committed to the SCM repo and pushed to origin");
            publishStubsToScmTask.setGroup(GROUP_NAME);
            ContractVerifierExtension.ContractRepository stubs = extension.getPublishStubsToScm().getContractRepository();
            ContractVerifierExtension.ContractRepository original = extension.getContractRepository();
            publishStubsToScmTask.getContractRepository().getRepositoryUrl().convention(stubs.getRepositoryUrl().orElse(original.getRepositoryUrl()));
            publishStubsToScmTask.getContractRepository().getUsername().convention(stubs.getUsername().orElse(original.getUsername()));
            publishStubsToScmTask.getContractRepository().getPassword().convention(stubs.getPassword().orElse(original.getPassword()));
            publishStubsToScmTask.getContractRepository().getProxyHost().convention(stubs.getProxyHost().orElse(original.getProxyHost()));
            publishStubsToScmTask.getContractRepository().getProxyPort().convention(stubs.getProxyPort().orElse(original.getProxyPort()));
            publishStubsToScmTask.getContractsMode().convention(extension.getContractsMode());
            publishStubsToScmTask.getDeleteStubsAfterTest().convention(extension.getDeleteStubsAfterTest());
            publishStubsToScmTask.getFailOnNoContracts().convention(extension.getFailOnNoContracts());
            publishStubsToScmTask.getContractsProperties().convention(extension.getContractsProperties());
            publishStubsToScmTask.getStubsDir().convention((Provider)extension.getStubsOutputDir());
            publishStubsToScmTask.dependsOn(new Object[]{generateClientStubs});
        });
    }

    private TaskProvider<GenerateClientStubsFromDslTask> createAndConfigureGenerateClientStubs(ContractVerifierExtension extension, TaskProvider<ContractsCopyTask> copyContracts) {
        TaskProvider task = this.project.getTasks().register("generateClientStubs", GenerateClientStubsFromDslTask.class, generateClientStubs -> {
            generateClientStubs.setGroup(GROUP_NAME);
            generateClientStubs.setDescription("Generate client stubs from the contracts");
            generateClientStubs.getContractsDslDir().convention(copyContracts.flatMap(ContractsCopyTask::getCopiedContractsFolder));
            generateClientStubs.getExcludedFiles().convention(extension.getExcludedFiles());
            generateClientStubs.getExcludeBuildFolders().convention(extension.getExcludeBuildFolders());
            generateClientStubs.getClasspath().from(new Object[]{this.project.getConfigurations().getByName(CONTRACT_TEST_GENERATOR_RUNTIME_CLASSPATH_CONFIGURATION_NAME)});
            generateClientStubs.getStubsOutputDir().convention(extension.getStubsOutputDir().dir(this.buildRootPath("mappings")));
            generateClientStubs.dependsOn(new Object[]{copyContracts});
        });
        return task;
    }

    private void createAndConfigureStubsJarTasks(ContractVerifierExtension extension, TaskProvider<GenerateClientStubsFromDslTask> generateClientStubs) {
        TaskProvider verifierStubsJar = this.project.getTasks().register(VERIFIER_STUBS_JAR_TASK_NAME, Jar.class);
        verifierStubsJar.configure(stubsJar -> {
            stubsJar.setDescription("Creates the stubs JAR task");
            stubsJar.setGroup(GROUP_NAME);
            stubsJar.getArchiveBaseName().convention(this.project.provider(() -> ((Project)this.project).getName()));
            stubsJar.getArchiveClassifier().convention(extension.getStubsSuffix());
            stubsJar.from(new Object[]{extension.getStubsOutputDir()});
            stubsJar.dependsOn(new Object[]{generateClientStubs});
        });
        this.project.artifacts(artifactHandler -> artifactHandler.add("archives", (Object)verifierStubsJar));
        this.createAndConfigureMavenPublishPlugin((TaskProvider<Jar>)verifierStubsJar, extension);
    }

    @Deprecated
    private void createAndConfigureMavenPublishPlugin(TaskProvider<Jar> stubsTask, ContractVerifierExtension extension) {
        if (!this.classIsOnClasspath("org.gradle.api.publish.maven.plugins.MavenPublishPlugin")) {
            this.project.getLogger().debug("Maven Publish Plugin is not present - won't add default publication");
            return;
        }
        this.project.afterEvaluate(inner -> {
            this.project.getLogger().debug("Spring Cloud Contract Verifier Plugin: Generating default publication");
            if (((Boolean)extension.getDisableStubPublication().get()).booleanValue()) {
                this.project.getLogger().info("You've switched off the stub publication - won't add default publication");
                return;
            }
            this.project.getPlugins().withType(MavenPublishPlugin.class, publishingPlugin -> {
                PublishingExtension publishingExtension = (PublishingExtension)this.project.getExtensions().findByType(PublishingExtension.class);
                if (this.hasStubsPublication(publishingExtension)) {
                    this.project.getLogger().info("Spring Cloud Contract Verifier Plugin: Stubs publication was present - won't create a new one. Remember about passing stubs as artifact");
                } else {
                    this.project.getLogger().debug("Spring Cloud Contract Verifier Plugin: Stubs publication is not present - will create one");
                    this.setPublications(publishingExtension, stubsTask);
                }
            });
        });
    }

    @Deprecated
    private void setPublications(PublishingExtension publishingExtension, TaskProvider<Jar> stubsTask) {
        this.project.getLogger().warn("Spring Cloud Contract Verifier Plugin: Creating stubs publication is deprecated");
        publishingExtension.publications(publicationsContainer -> publicationsContainer.create("stubs", MavenPublication.class, stubsPublication -> {
            stubsPublication.setArtifactId(this.project.getName());
            stubsPublication.artifact(stubsTask.get());
        }));
    }

    @Deprecated
    private boolean hasStubsPublication(PublishingExtension publishingExtension) {
        try {
            return publishingExtension.getPublications().getByName("stubs") != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private TaskProvider<ContractsCopyTask> createAndConfigureCopyContractsTask(ContractVerifierExtension extension) {
        TaskProvider task = this.project.getTasks().register("copyContracts", ContractsCopyTask.class, contractsCopyTask -> {
            contractsCopyTask.setGroup(GROUP_NAME);
            contractsCopyTask.setDescription("Copies contracts to the output folder");
            contractsCopyTask.getConvertToYaml().convention(extension.getConvertToYaml());
            contractsCopyTask.getFailOnNoContracts().convention(extension.getFailOnNoContracts());
            contractsCopyTask.getContractsDirectory().convention(extension.getContractsDslDir().flatMap(contractsDslDir -> this.project.provider(() -> {
                if (contractsDslDir.getAsFile().exists()) {
                    return contractsDslDir;
                }
                Directory legacyContractsDslDir = this.project.getLayout().getProjectDirectory().dir("src/test/resources/contracts");
                if (legacyContractsDslDir.getAsFile().exists()) {
                    this.project.getLogger().warn("Spring Cloud Contract Verifier Plugin: Locating contracts in <src/test/resources/contracts> is deprecated and will be removed in a future release. Please move them to <src/contractTest/resources/contracts>.");
                    return legacyContractsDslDir;
                }
                return null;
            })));
            contractsCopyTask.getContractDependency().getGroupId().convention(extension.getContractDependency().getGroupId());
            contractsCopyTask.getContractDependency().getArtifactId().convention(extension.getContractDependency().getArtifactId());
            contractsCopyTask.getContractDependency().getVersion().convention(extension.getContractDependency().getVersion());
            contractsCopyTask.getContractDependency().getClassifier().convention(extension.getContractDependency().getClassifier());
            contractsCopyTask.getContractDependency().getStringNotation().convention(extension.getContractDependency().getStringNotation());
            contractsCopyTask.getContractRepository().getRepositoryUrl().convention(extension.getContractRepository().getRepositoryUrl());
            contractsCopyTask.getContractRepository().getUsername().convention(extension.getContractRepository().getUsername());
            contractsCopyTask.getContractRepository().getPassword().convention(extension.getContractRepository().getPassword());
            contractsCopyTask.getContractRepository().getProxyHost().convention(extension.getContractRepository().getProxyHost());
            contractsCopyTask.getContractRepository().getProxyPort().convention(extension.getContractRepository().getProxyPort());
            contractsCopyTask.getContractsMode().convention(extension.getContractsMode());
            contractsCopyTask.getContractsProperties().convention(extension.getContractsProperties());
            contractsCopyTask.getContractsPath().convention(extension.getContractsPath());
            contractsCopyTask.getExcludeBuildFolders().convention(extension.getExcludeBuildFolders());
            contractsCopyTask.getDeleteStubsAfterTest().convention(extension.getDeleteStubsAfterTest());
            contractsCopyTask.getClasspath().from(new Object[]{this.project.getConfigurations().getByName(CONTRACT_TEST_GENERATOR_RUNTIME_CLASSPATH_CONFIGURATION_NAME)});
            contractsCopyTask.getCopiedContractsFolder().convention(extension.getStubsOutputDir().dir(this.buildRootPath(EXTENSION_NAME)));
            contractsCopyTask.getBackupContractsFolder().convention(extension.getStubsOutputDir().dir(this.buildRootPath("original")));
        });
        return task;
    }

    @Deprecated
    private boolean classIsOnClasspath(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception e) {
            this.project.getLogger().debug("Maven Publish Plugin is not available");
            return false;
        }
    }

    private Provider<String> buildRootPath(String path) {
        return this.project.provider(() -> {
            StringBuilder builder = new StringBuilder();
            builder.append("META-INF").append(File.separator).append(this.project.getGroup()).append(File.separator).append(this.project.getName()).append(File.separator).append(this.project.getVersion()).append(File.separator).append(path);
            return builder.toString();
        });
    }
}

