/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.converter;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.verifier.converter.StubPostProcessor;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;

public interface StubGenerator<T> {
    default public boolean canReadStubMapping(File mapping) {
        return mapping.getName().endsWith(this.fileExtension());
    }

    public Map<Contract, String> convertContents(String var1, ContractMetadata var2);

    default public T postProcessStubMapping(T stubMapping, Contract contract) {
        List processors = StubPostProcessor.PROCESSORS.stream().filter(p -> p.isApplicable(contract)).collect(Collectors.toList());
        if (processors.isEmpty()) {
            return this.defaultStubMappingPostProcessing(stubMapping, contract);
        }
        T stub = stubMapping;
        for (StubPostProcessor processor : processors) {
            stub = processor.postProcess(stub, contract);
        }
        return stub;
    }

    default public T defaultStubMappingPostProcessing(T stubMapping, Contract contract) {
        return stubMapping;
    }

    public String generateOutputFileNameForInput(String var1);

    default public String fileExtension() {
        return ".json";
    }
}

