/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import java.util.Collections;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetaData;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessorRegistrar;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.properties.ConfigurationPropertiesBeans;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={ConfigurationPropertiesBindingPostProcessor.class})
public class ConfigurationPropertiesRebinderAutoConfiguration
implements ApplicationContextAware,
SmartInitializingSingleton {
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public ConfigurationPropertiesBeans configurationPropertiesBeans() {
        ConfigurationBeanFactoryMetaData metaData = (ConfigurationBeanFactoryMetaData)this.context.getBean(ConfigurationPropertiesBindingPostProcessorRegistrar.BINDER_BEAN_NAME + ".store", ConfigurationBeanFactoryMetaData.class);
        ConfigurationPropertiesBeans beans = new ConfigurationPropertiesBeans();
        beans.setBeanMetaDataStore(metaData);
        return beans;
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public ConfigurationPropertiesRebinder configurationPropertiesRebinder(ConfigurationPropertiesBeans beans, ConfigurationPropertiesBindingPostProcessor binder) {
        ConfigurationPropertiesRebinder rebinder = new ConfigurationPropertiesRebinder(binder, beans);
        return rebinder;
    }

    public void afterSingletonsInstantiated() {
        this.context.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(Collections.emptySet()));
    }
}

