/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.environment;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource
public class EnvironmentManager
implements ApplicationEventPublisherAware {
    private static final String MANAGER_PROPERTY_SOURCE = "manager";
    private Map<String, Object> map = new LinkedHashMap<String, Object>();
    private ConfigurableEnvironment environment;
    private ApplicationEventPublisher publisher;

    public EnvironmentManager(ConfigurableEnvironment environment) {
        this.environment = environment;
        MutablePropertySources sources = environment.getPropertySources();
        if (sources.contains(MANAGER_PROPERTY_SOURCE)) {
            Map map;
            this.map = map = (Map)sources.get(MANAGER_PROPERTY_SOURCE).getSource();
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @ManagedOperation
    public Map<String, Object> reset() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.map);
        if (!this.map.isEmpty()) {
            Set<String> keys = this.map.keySet();
            this.map.clear();
            this.publish(new EnvironmentChangeEvent(keys));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void setProperty(String name, String value) {
        if (!this.environment.getPropertySources().contains(MANAGER_PROPERTY_SOURCE)) {
            Map<String, Object> map = this.map;
            synchronized (map) {
                if (!this.environment.getPropertySources().contains(MANAGER_PROPERTY_SOURCE)) {
                    MapPropertySource source = new MapPropertySource(MANAGER_PROPERTY_SOURCE, this.map);
                    this.environment.getPropertySources().addFirst((PropertySource)source);
                }
            }
        }
        if (!value.equals(this.environment.getProperty(name))) {
            this.map.put(name, value);
            this.publish(new EnvironmentChangeEvent(Collections.singleton(name)));
        }
    }

    @ManagedOperation
    public Object getProperty(String name) {
        return this.environment.getProperty(name);
    }

    private void publish(EnvironmentChangeEvent environmentChangeEvent) {
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)environmentChangeEvent);
        }
    }
}

