/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.consul.discovery.ConsulCatalogWatch;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.ConsulLifecycle;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.discovery.TtlScheduler;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnConsulEnabled
@ConditionalOnProperty(value={"spring.cloud.consul.discovery.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties
public class ConsulDiscoveryClientConfiguration {
    @Autowired
    private ConsulClient consulClient;
    @Autowired(required=false)
    private ServerProperties serverProperties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.consul.discovery.heartbeat.enabled"})
    public TtlScheduler ttlScheduler(HeartbeatProperties heartbeatProperties) {
        return new TtlScheduler(heartbeatProperties, this.consulClient);
    }

    @Bean
    public HeartbeatProperties heartbeatProperties() {
        return new HeartbeatProperties();
    }

    @Bean
    public ConsulDiscoveryProperties consulDiscoveryProperties(InetUtils inetUtils) {
        return new ConsulDiscoveryProperties(inetUtils);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsulDiscoveryClient consulDiscoveryClient(ConsulDiscoveryProperties discoveryProperties, ApplicationContext context) {
        ConsulDiscoveryClient discoveryClient = new ConsulDiscoveryClient(this.consulClient, discoveryProperties, new LifecycleRegistrationResolver(context));
        discoveryClient.setServerProperties(this.serverProperties);
        return discoveryClient;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.cloud.consul.discovery.catalogServicesWatch.enabled"}, matchIfMissing=true)
    public ConsulCatalogWatch consulCatalogWatch(ConsulDiscoveryProperties discoveryProperties) {
        return new ConsulCatalogWatch(discoveryProperties, this.consulClient);
    }

    class LifecycleRegistrationResolver
    implements ConsulDiscoveryClient.LocalResolver {
        private ApplicationContext context;

        public LifecycleRegistrationResolver(ApplicationContext context) {
            this.context = context;
        }

        @Override
        public String getInstanceId() {
            ConsulRegistration registration = this.getBean(ConsulRegistration.class);
            if (registration != null) {
                return registration.getInstanceId();
            }
            ConsulLifecycle lifecycle = this.getBean(ConsulLifecycle.class);
            if (lifecycle != null) {
                return lifecycle.getInstanceId();
            }
            throw new IllegalStateException("Must have one of ConsulRegistration or ConsulLifecycle");
        }

        @Override
        public Integer getPort() {
            ConsulRegistration registration = this.getBean(ConsulRegistration.class);
            if (registration != null) {
                return registration.getService().getPort();
            }
            ConsulLifecycle lifecycle = this.getBean(ConsulLifecycle.class);
            if (lifecycle != null) {
                return lifecycle.getConfiguredPort();
            }
            throw new IllegalStateException("Must have one of ConsulRegistration or ConsulLifecycle");
        }

        <T> T getBean(Class<T> type) {
            try {
                return (T)this.context.getBean(type);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                return null;
            }
        }
    }
}

