/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault;

import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.web.client.RestOperations;

public abstract class SpringVaultClientAuthenticationProvider {
    protected static final String VAULT_PROPERTIES_PREFIX = "spring.cloud.config.server.vault.";
    protected final VaultEnvironmentProperties.AuthenticationMethod supportedAuthenticationMethod;

    protected SpringVaultClientAuthenticationProvider(VaultEnvironmentProperties.AuthenticationMethod supportedAuthenticationMethod) {
        this.supportedAuthenticationMethod = supportedAuthenticationMethod;
    }

    public boolean supports(VaultEnvironmentProperties properties) {
        return properties.getAuthentication().equals((Object)this.supportedAuthenticationMethod);
    }

    public abstract ClientAuthentication getClientAuthentication(VaultEnvironmentProperties var1, RestOperations var2, RestOperations var3);

    protected String missingPropertyForAuthMethod(String propertyName, VaultEnvironmentProperties.AuthenticationMethod authenticationMethod) {
        return "The 'spring.cloud.config.server.vault." + propertyName + "' property must be provided when the " + String.valueOf((Object)authenticationMethod) + " authentication method is specified.";
    }

    protected String missingClassForAuthMethod(String className, String classArtifact, VaultEnvironmentProperties.AuthenticationMethod authenticationMethod) {
        return className + "(" + classArtifact + ") must be on the classpath when the " + String.valueOf((Object)authenticationMethod) + " authentication method is specified";
    }

    protected void assertClassPresent(String className, String message) {
        Assert.isTrue((boolean)ClassUtils.isPresent((String)className, (ClassLoader)this.getClass().getClassLoader()), (String)message);
    }
}

