/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.core.Ordered;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractVaultEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private static final String DEFAULT_PROFILE = "default";
    private static final Log log = LogFactory.getLog(AbstractVaultEnvironmentRepository.class);
    protected final ObjectProvider<HttpServletRequest> request;
    protected final EnvironmentWatch watch;
    protected String defaultKey;
    @NotEmpty
    protected String profileSeparator;
    protected final boolean enableLabel;
    protected final String defaultLabel;
    protected int order;

    public AbstractVaultEnvironmentRepository(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, VaultEnvironmentProperties properties) {
        this.defaultKey = properties.getDefaultKey();
        this.profileSeparator = properties.getProfileSeparator();
        this.enableLabel = properties.isEnableLabel();
        this.defaultLabel = properties.getDefaultLabel();
        this.order = properties.getOrder();
        this.request = request;
        this.watch = watch;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        if (ObjectUtils.isEmpty((Object)profile)) {
            profile = DEFAULT_PROFILE;
        }
        if (ObjectUtils.isEmpty((Object)label)) {
            label = this.defaultLabel;
        }
        Environment environment = new Environment(application, this.split(profile), label, null, this.getWatchState());
        List<String> profiles = this.normalize(profile, DEFAULT_PROFILE);
        List<String> applications = this.normalize(application, this.defaultKey);
        for (String prof : profiles) {
            for (String app : applications) {
                String key = this.vaultKey(app, prof, label);
                String data = this.read(key);
                if (data == null) continue;
                YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
                yaml.setResources(new Resource[]{new ByteArrayResource(data.getBytes())});
                Properties properties = yaml.getObject();
                if (properties == null || properties.isEmpty()) continue;
                environment.add(new PropertySource("vault:" + key, (Map)properties));
            }
        }
        return environment;
    }

    protected abstract String read(String var1);

    private String vaultKey(String application, String profile, String label) {
        Object key = application;
        if (this.enableLabel) {
            key = (String)key + this.profileSeparator + profile;
            key = (String)key + this.profileSeparator + label;
        } else if (!DEFAULT_PROFILE.equals(profile)) {
            key = (String)key + this.profileSeparator + profile;
        }
        return key;
    }

    private String getWatchState() {
        HttpServletRequest servletRequest = (HttpServletRequest)this.request.getIfAvailable();
        if (servletRequest != null) {
            try {
                String state = servletRequest.getHeader("X-Config-State");
                return this.watch.watch(state);
            }
            catch (IllegalStateException e) {
                log.debug((Object)"Could not get state.", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private List<String> normalize(String commaDelimitedItems, String defaultItem) {
        List<String> items = Stream.concat(Stream.of(defaultItem), Arrays.stream(this.split(commaDelimitedItems))).distinct().filter(Predicate.not(ObjectUtils::isEmpty)).collect(Collectors.toList());
        Collections.reverse(items);
        return items;
    }

    private String[] split(String str) {
        return StringUtils.commaDelimitedListToStringArray((String)str);
    }

    public void setDefaultKey(String defaultKey) {
        this.defaultKey = defaultKey;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

