/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.springframework.cloud.config.server.environment.S3ConfigFile;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

class PropertyS3ConfigFile
extends S3ConfigFile {
    PropertyS3ConfigFile(String application, String profile, String label, String bucketName, boolean useApplicationAsDirectory, S3Client s3Client) {
        super(application, profile, label, bucketName, useApplicationAsDirectory, s3Client);
        this.properties = this.read();
    }

    @Override
    public Properties read() {
        if (this.properties != null) {
            return this.properties;
        }
        Properties props = new Properties();
        try (ResponseInputStream<GetObjectResponse> in = this.getObject();){
            props.load((InputStream)in);
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception thrown when reading property file", (Throwable)e);
            throw new IllegalStateException("Cannot load environment", e);
        }
        return props;
    }

    @Override
    protected List<String> getExtensions() {
        return List.of("properties");
    }
}

