/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.NativeEnvironmentProperties;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepository;
import org.springframework.core.env.ConfigurableEnvironment;

public class NativeEnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<NativeEnvironmentRepository, NativeEnvironmentProperties> {
    private ConfigurableEnvironment environment;
    private ConfigServerProperties properties;
    private final ObservationRegistry observationRegistry;

    public NativeEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties properties, ObservationRegistry observationRegistry) {
        this.environment = environment;
        this.properties = properties;
        this.observationRegistry = observationRegistry;
    }

    @Override
    public NativeEnvironmentRepository build(NativeEnvironmentProperties environmentProperties) {
        NativeEnvironmentRepository repository = new NativeEnvironmentRepository(this.environment, environmentProperties, this.observationRegistry);
        if (this.properties.getDefaultLabel() != null) {
            repository.setDefaultLabel(this.properties.getDefaultLabel());
        }
        return repository;
    }
}

