/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import org.springframework.cloud.config.server.environment.VaultKvAccessStrategy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

abstract class VaultKvAccessStrategySupport
implements VaultKvAccessStrategy {
    private final String baseUrl;
    private final RestOperations rest;

    VaultKvAccessStrategySupport(String baseUrl, RestOperations rest) {
        this.baseUrl = baseUrl;
        this.rest = rest;
    }

    abstract String getPath();

    abstract String extractDataFromBody(VaultKvAccessStrategy.VaultResponse var1);

    @Override
    public String getData(HttpHeaders headers, String backend, String key) {
        try {
            String urlTemplate = String.format("%s/v1/%s/%s", this.baseUrl, backend, this.getPath());
            ResponseEntity response = this.rest.exchange(urlTemplate, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), VaultKvAccessStrategy.VaultResponse.class, new Object[]{key});
            HttpStatusCode status = response.getStatusCode();
            if (status == HttpStatus.OK) {
                return this.extractDataFromBody((VaultKvAccessStrategy.VaultResponse)response.getBody());
            }
        }
        catch (HttpStatusCodeException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw e;
        }
        return null;
    }
}

