/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.secretmanager;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleConfigProvider;
import org.springframework.util.StringUtils;

public class HttpHeaderGoogleConfigProvider
implements GoogleConfigProvider {
    public static final String PROJECT_ID_HEADER = "X-Project-ID";
    public static final String ACCESS_TOKEN_HEADER = "X-Config-Token";
    public static final String PREFIX_HEADER = "X-Secret-Prefix";
    private ObjectProvider<HttpServletRequest> httpRequest;

    public HttpHeaderGoogleConfigProvider(ObjectProvider<HttpServletRequest> request) {
        this.httpRequest = request;
    }

    @Override
    public String getValue(String key, Boolean mandatory) {
        HttpServletRequest request = (HttpServletRequest)this.httpRequest.getIfAvailable();
        if (request == null) {
            throw new IllegalStateException("No HttpServletRequest available");
        }
        String value = request.getHeader(key);
        if (!StringUtils.hasLength((String)value) && mandatory.booleanValue()) {
            throw new IllegalArgumentException("Missing required header in HttpServletRequest: " + key);
        }
        return value;
    }
}

