/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.CredhubEnvironmentProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.core.Ordered;
import org.springframework.credhub.core.CredHubOperations;
import org.springframework.credhub.support.CredentialDetails;
import org.springframework.credhub.support.CredentialName;
import org.springframework.credhub.support.SimpleCredentialName;
import org.springframework.credhub.support.json.JsonCredential;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CredhubEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private static final String DEFAULT_PROFILE = "default";
    private static final String DEFAULT_APPLICATION = "application";
    private final String path;
    private final String defaultLabel;
    private int order;
    private final CredHubOperations credHubOperations;

    public CredhubEnvironmentRepository(CredHubOperations credHubOperations) {
        this(credHubOperations, new CredhubEnvironmentProperties());
    }

    public CredhubEnvironmentRepository(CredHubOperations credHubOperations, CredhubEnvironmentProperties properties) {
        this.credHubOperations = credHubOperations;
        this.path = properties.getPath();
        this.defaultLabel = properties.getDefaultLabel();
        this.order = properties.getOrder();
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        if (ObjectUtils.isEmpty((Object)profile)) {
            profile = DEFAULT_PROFILE;
        }
        if (ObjectUtils.isEmpty((Object)label)) {
            label = this.defaultLabel;
        }
        List<String> applications = this.normalize(application, DEFAULT_APPLICATION);
        List<String> profiles = this.normalize(profile, DEFAULT_PROFILE);
        Environment environment = new Environment(application, this.split(profile), label, null, null);
        for (String prof : profiles) {
            for (String app : applications) {
                this.addPropertySource(environment, app, prof, label);
            }
        }
        return environment;
    }

    private List<String> normalize(String commaDelimitedItems, String defaultItem) {
        List<String> items = Stream.concat(Stream.of(defaultItem), Arrays.stream(this.split(commaDelimitedItems))).distinct().collect(Collectors.toList());
        Collections.reverse(items);
        return items;
    }

    private void addPropertySource(Environment environment, String application, String profile, String label) {
        Map<Object, Object> properties = this.findProperties(application, profile, label);
        if (!properties.isEmpty() || environment.getPropertySources().isEmpty()) {
            PropertySource propertySource = new PropertySource("credhub-" + application + "-" + profile + "-" + label, properties);
            environment.add(propertySource);
        }
    }

    private Map<Object, Object> findProperties(String application, String profile, String label) {
        String path = Path.of("/", this.path, application, profile, label).toString();
        return this.credHubOperations.credentials().findByPath(path).stream().map(credentialSummary -> credentialSummary.getName().getName()).map(name -> this.credHubOperations.credentials().getByName((CredentialName)new SimpleCredentialName(new String[]{name}), JsonCredential.class)).map(CredentialDetails::getValue).flatMap(jsonCredential -> jsonCredential.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b));
    }

    private String[] split(String str) {
        return StringUtils.commaDelimitedListToStringArray((String)str);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

