/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault.authentication;

import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.GcpComputeAuthentication;
import org.springframework.vault.authentication.GcpComputeAuthenticationOptions;
import org.springframework.web.client.RestOperations;

public class GcpGceClientAuthenticationProvider
extends SpringVaultClientAuthenticationProvider {
    public GcpGceClientAuthenticationProvider() {
        super(VaultEnvironmentProperties.AuthenticationMethod.GCP_GCE);
    }

    @Override
    public ClientAuthentication getClientAuthentication(VaultEnvironmentProperties vaultProperties, RestOperations vaultRestOperations, RestOperations externalRestOperations) {
        VaultEnvironmentProperties.GcpGceProperties gcp = vaultProperties.getGcpGce();
        Assert.hasText((String)gcp.getRole(), (String)this.missingPropertyForAuthMethod("gcp-iam.role", VaultEnvironmentProperties.AuthenticationMethod.GCP_GCE));
        GcpComputeAuthenticationOptions.GcpComputeAuthenticationOptionsBuilder builder = GcpComputeAuthenticationOptions.builder().path(gcp.getGcpPath()).role(gcp.getRole());
        if (StringUtils.hasText((String)gcp.getServiceAccount())) {
            builder.serviceAccount(gcp.getServiceAccount());
        }
        return new GcpComputeAuthentication(builder.build(), vaultRestOperations, externalRestOperations);
    }
}

