/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.config.server.environment.CompositeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathCompositeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={CompositeEnvironmentRepository.class})
public class CompositeConfiguration {
    private List<EnvironmentRepository> environmentRepos = new ArrayList<EnvironmentRepository>();

    @Bean
    @Primary
    @ConditionalOnBean(value={SearchPathLocator.class})
    public SearchPathCompositeEnvironmentRepository searchPathCompositeEnvironmentRepository() {
        return new SearchPathCompositeEnvironmentRepository(this.environmentRepos);
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={SearchPathLocator.class})
    public CompositeEnvironmentRepository compositeEnvironmentRepository() {
        return new CompositeEnvironmentRepository(this.environmentRepos);
    }

    @Autowired
    public void setEnvironmentRepos(List<EnvironmentRepository> repos) {
        this.environmentRepos = repos;
    }
}

