/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault;

import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientConfiguration;
import org.springframework.cloud.config.server.environment.vault.SpringVaultEnvironmentRepository;
import org.springframework.vault.core.VaultKeyValueOperations;
import org.springframework.vault.core.VaultKeyValueOperationsSupport;
import org.springframework.vault.core.VaultTemplate;

public class SpringVaultEnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<SpringVaultEnvironmentRepository, VaultEnvironmentProperties> {
    private final ObjectProvider<HttpServletRequest> request;
    private final EnvironmentWatch watch;
    private final SpringVaultClientConfiguration clientConfiguration;

    public SpringVaultEnvironmentRepositoryFactory(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, SpringVaultClientConfiguration clientConfiguration) {
        this.request = request;
        this.watch = watch;
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public SpringVaultEnvironmentRepository build(VaultEnvironmentProperties vaultProperties) {
        VaultTemplate vaultTemplate = this.clientConfiguration.vaultTemplate();
        VaultKeyValueOperations accessStrategy = this.buildVaultAccessStrategy(vaultProperties, vaultTemplate);
        return new SpringVaultEnvironmentRepository(this.request, this.watch, vaultProperties, accessStrategy);
    }

    private VaultKeyValueOperations buildVaultAccessStrategy(VaultEnvironmentProperties vaultProperties, VaultTemplate vaultTemplate) {
        String backend = vaultProperties.getBackend();
        int version = vaultProperties.getKvVersion();
        switch (version) {
            case 1: {
                return vaultTemplate.opsForKeyValue(backend, VaultKeyValueOperationsSupport.KeyValueBackend.KV_1);
            }
            case 2: {
                return vaultTemplate.opsForKeyValue(backend, VaultKeyValueOperationsSupport.KeyValueBackend.KV_2);
            }
        }
        throw new IllegalArgumentException("No support for given Vault k/v backend version " + version);
    }
}

