/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class EnvironmentPropertySource
extends PropertySource<Environment> {
    private static final Pattern ESCAPED_PLACEHOLDERS = Pattern.compile("[\\\\]{1,2}\\$\\{");

    public EnvironmentPropertySource(Environment sources) {
        super("cloudEnvironment", (Object)sources);
    }

    public static StandardEnvironment prepareEnvironment(Environment environment) {
        StandardEnvironment standardEnvironment = new StandardEnvironment();
        standardEnvironment.getPropertySources().remove("systemProperties");
        standardEnvironment.getPropertySources().remove("systemEnvironment");
        standardEnvironment.getPropertySources().addFirst((PropertySource)new EnvironmentPropertySource(environment));
        return standardEnvironment;
    }

    public static String resolvePlaceholders(StandardEnvironment preparedEnvironment, String text) {
        text = ESCAPED_PLACEHOLDERS.matcher(text).replaceAll("\\$_{");
        return preparedEnvironment.resolvePlaceholders(text).replace("$_{", "${");
    }

    public Object getProperty(String name) {
        for (org.springframework.cloud.config.environment.PropertySource source : ((Environment)this.getSource()).getPropertySources()) {
            Map map = source.getSource();
            if (!map.containsKey(name)) continue;
            return map.get(name);
        }
        return null;
    }
}

