/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.bootstrap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.config.EnvironmentRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryPropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.config.server.bootstrap"})
public class ConfigServerBootstrapConfiguration {

    @EnableConfigurationProperties(value={ConfigServerProperties.class})
    @Import(value={EnvironmentRepositoryConfiguration.class})
    protected static class LocalPropertySourceLocatorConfiguration {
        @Autowired
        private EnvironmentRepository repository;
        @Autowired
        private ConfigClientProperties client;
        @Autowired
        private ConfigServerProperties server;

        protected LocalPropertySourceLocatorConfiguration() {
        }

        @Bean
        public EnvironmentRepositoryPropertySourceLocator environmentRepositoryPropertySourceLocator() {
            return new EnvironmentRepositoryPropertySourceLocator(this.repository, this.client.getName(), this.client.getProfile(), this.getDefaultLabel());
        }

        private String getDefaultLabel() {
            if (StringUtils.hasText((String)this.client.getLabel())) {
                return this.client.getLabel();
            }
            if (StringUtils.hasText((String)this.server.getDefaultLabel())) {
                return this.server.getDefaultLabel();
            }
            return null;
        }
    }
}

